/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.util;

import java.util.Stack;

public final class ThreadPool {
    private boolean m_enabled = true;
    private int m_nextId = 1;
    private final Stack m_pool = new Stack();
    private final ThreadGroup m_threadGroup;
    private static final boolean s_trace = false;

    public ThreadPool(ThreadGroup g) {
        this.m_threadGroup = g;
    }

    public synchronized void clear() {
        while (!this.m_pool.empty()) {
            Runner r = (Runner)this.m_pool.pop();
            r.stop();
        }
    }

    public synchronized void disable() {
        this.clear();
        this.m_enabled = false;
    }

    public boolean empty() {
        return this.m_pool.empty();
    }

    public synchronized void enable() {
        this.m_enabled = true;
    }

    public synchronized Thread get(Runnable target) {
        Runner r;
        if (this.m_pool.empty()) {
            r = new Runner(this.m_nextId);
            ++this.m_nextId;
        } else {
            r = (Runner)this.m_pool.pop();
        }
        r.execute(target);
        return r.thread();
    }

    public int size() {
        return this.m_pool.size();
    }

    private synchronized void release(Runner r) {
        if (this.m_enabled) {
            this.m_pool.push(r);
        } else {
            r.stop();
        }
    }

    private final class Runner
    implements Runnable {
        private final int m_id;
        private Runnable m_target;
        private final Thread m_thread;
        private boolean m_timeToDie;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.mesquite.util.ThreadPool$Runner");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public Runner(int id) {
            this.m_id = id;
            this.m_thread = new Thread(ThreadPool.this.m_threadGroup, this);
            this.m_timeToDie = false;
            this.m_thread.setDaemon(true);
            this.m_thread.start();
        }

        public synchronized void execute(Runnable target) {
            if (!$assertionsDisabled && this.m_target != null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && target == null) {
                throw new AssertionError();
            }
            this.m_target = target;
            this.notifyAll();
        }

        public synchronized void stop() {
            this.m_target = null;
            this.m_timeToDie = true;
            this.notifyAll();
        }

        public void run() {
            this.debugTrace("Start");
            while (true) {
                this.debugTrace("Waiting");
                this.waitForTarget();
                this.debugTrace("Running");
                try {
                    this.m_target.run();
                }
                catch (ThreadDeath threadDeath) {
                    // empty catch block
                }
                this.debugTrace("Finished");
                this.m_target = null;
                ThreadPool.this.release(this);
            }
        }

        public Thread thread() {
            return this.m_thread;
        }

        private void debugTrace(String msg) {
        }

        private synchronized void waitForTarget() {
            while (this.m_target == null) {
                if (this.m_timeToDie) {
                    this.debugTrace("End");
                    throw new ThreadDeath();
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

