/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.text;

import com.mesquite.text.Align;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.StringCharacterIterator;

public class Format {
    public static String format(String fmt, Object[] args) {
        StringBuffer result = new StringBuffer();
        int argIndex = 0;
        StringCharacterIterator it = new StringCharacterIterator(fmt);
        char c = it.first();
        while (c != '\uffff') {
            if (c != '%') {
                result.append(c);
                c = it.next();
                continue;
            }
            it.next();
            boolean alignLeft = Format.parseAlignLeft(it);
            int width = Format.parseWidth(it);
            int precision = Format.parsePrecision(it);
            char type = Format.parseType(it);
            Object arg = args[argIndex];
            ++argIndex;
            String s = null;
            switch (type) {
                case '%': {
                    s = "%";
                    break;
                }
                case 'c': 
                case 'd': {
                    s = arg.toString();
                    break;
                }
                case 'x': {
                    Integer x = (Integer)arg;
                    s = Integer.toHexString(x);
                    break;
                }
                case 's': {
                    s = arg.toString();
                    if (precision < 0 || precision >= s.length()) break;
                    s = s.substring(0, precision);
                    break;
                }
                case 'f': {
                    StringBuffer pattern = new StringBuffer("0");
                    if (precision < 0) {
                        precision = 6;
                    }
                    if (precision > 0) {
                        pattern.append('.');
                        while (precision > 0) {
                            pattern.append('0');
                            --precision;
                        }
                    }
                    DecimalFormat f = new DecimalFormat(pattern.toString());
                    s = f.format(arg).toString();
                }
            }
            s = alignLeft ? Align.left(s, width) : Align.right(s, width);
            result.append(s);
            c = it.current();
        }
        return result.toString();
    }

    public static void printf(PrintStream s, String fmt, Object[] args) {
        int argIndex = 0;
        StringCharacterIterator it = new StringCharacterIterator(fmt);
        char c = it.first();
        while (c != '\uffff') {
            if (c != '%') {
                s.print(c);
                c = it.next();
                continue;
            }
            it.next();
            boolean alignLeft = Format.parseAlignLeft(it);
            int width = Format.parseWidth(it);
            int precision = Format.parsePrecision(it);
            char type = Format.parseType(it);
            Object arg = args[argIndex];
            ++argIndex;
            String str = null;
            switch (type) {
                case '%': {
                    str = "%";
                    break;
                }
                case 'c': 
                case 'd': {
                    str = arg.toString();
                    break;
                }
                case 'x': {
                    Integer x = (Integer)arg;
                    str = Integer.toHexString(x);
                    break;
                }
                case 's': {
                    str = arg.toString();
                    if (precision < 0 || precision >= str.length()) break;
                    str = str.substring(0, precision);
                    break;
                }
                case 'f': {
                    StringBuffer pattern = new StringBuffer("0");
                    if (precision < 0) {
                        precision = 6;
                    }
                    if (precision > 0) {
                        pattern.append('.');
                        while (precision > 0) {
                            pattern.append('0');
                            --precision;
                        }
                    }
                    DecimalFormat f = new DecimalFormat(pattern.toString());
                    str = f.format(arg).toString();
                }
            }
            str = alignLeft ? Align.left(str, width) : Align.right(str, width);
            s.print(str);
            c = it.current();
        }
    }

    private static boolean parseAlignLeft(StringCharacterIterator it) {
        if (it.current() == '-') {
            it.next();
            return true;
        }
        return false;
    }

    private static int parseInt(StringCharacterIterator it) {
        char c;
        int result = 0;
        while ((c = it.current()) >= '0' && c <= '9') {
            result = result * 10 + (c - 48);
            it.next();
        }
        return result;
    }

    private static int parseWidth(StringCharacterIterator it) {
        return Format.parseInt(it);
    }

    private static int parsePrecision(StringCharacterIterator it) {
        if (it.current() != '.') {
            return -1;
        }
        it.next();
        return Format.parseInt(it);
    }

    private static char parseType(StringCharacterIterator it) {
        char c = it.current();
        it.next();
        return c;
    }
}

