/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.text;

public final class Align {
    public static String left(String text, int width, char fill) {
        int padLength = width - text.length();
        return String.valueOf(text) + Align.pad(fill, padLength);
    }

    public static String left(String text, int width) {
        return Align.left(text, width, ' ');
    }

    public static String center(String text, int width, char fill) {
        int len = text.length();
        int leftPad = width / 2 - len / 2;
        int rightPad = width - len - leftPad;
        return String.valueOf(Align.pad(fill, leftPad)) + text + Align.pad(fill, rightPad);
    }

    public static String center(String text, int width) {
        return Align.center(text, width, ' ');
    }

    public static String right(String text, int width, char fill) {
        int padLength = width - text.length();
        return String.valueOf(Align.pad(fill, padLength)) + text;
    }

    public static String right(String text, int width) {
        return Align.right(text, width, ' ');
    }

    public static String pad(char fill, int len) {
        if (len <= 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.setLength(len);
        int i = 0;
        while (i < len) {
            buf.setCharAt(i, fill);
            ++i;
        }
        return buf.toString();
    }
}

