/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.queue;

import com.mesquite.queue.PriorityQueue;
import com.mesquite.util.Comparators;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class TreePriorityQueue
implements PriorityQueue {
    private final Comparator m_comparator;
    private final TreeSet m_elements = new TreeSet(Comparators.reverseComparator());
    private int m_nextElementId = 0;
    private final Map m_obj2element = new HashMap();

    public TreePriorityQueue() {
        this(null);
    }

    public TreePriorityQueue(Comparator c) {
        this.m_comparator = c != null ? c : Comparators.defaultComparator();
    }

    public boolean add(Object o) {
        Element e = new Element(o);
        this.m_obj2element.put(o, e);
        this.m_elements.add(e);
        return true;
    }

    public void clear() {
        this.m_elements.clear();
    }

    public Object element() {
        Element e = (Element)this.m_elements.first();
        return e.object;
    }

    public Object firstElement() {
        Element e = (Element)this.m_elements.first();
        return e.object;
    }

    public Object lastElement() {
        Element e = (Element)this.m_elements.last();
        return e.object;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterator iterator() {
        return new ElementIterator();
    }

    public Object peek() {
        if (this.isEmpty()) {
            return null;
        }
        return this.element();
    }

    public Object poll() {
        if (this.isEmpty()) {
            return null;
        }
        return this.remove();
    }

    public int size() {
        return this.m_elements.size();
    }

    public Object remove() {
        Element e = (Element)this.m_elements.first();
        this.m_elements.remove(e);
        this.m_obj2element.remove(e.object);
        return e.object;
    }

    public boolean remove(Object o) {
        Element e = (Element)this.m_obj2element.get(o);
        this.m_elements.remove(e);
        return true;
    }

    public void replace(Object from, Object to) {
        Element e = (Element)this.m_obj2element.get(from);
        this.m_elements.remove(e);
        e.object = to;
        this.m_elements.add(e);
    }

    private final class Element
    implements Comparable {
        public Object object;
        public final int id;

        public Element(Object o) {
            this.object = o;
            this.id = TreePriorityQueue.this.m_nextElementId;
            TreePriorityQueue treePriorityQueue2 = TreePriorityQueue.this;
            treePriorityQueue2.m_nextElementId = treePriorityQueue2.m_nextElementId + 1;
        }

        public int compareTo(Object other) {
            Element e = (Element)other;
            int result = TreePriorityQueue.this.m_comparator.compare(this.object, e.object);
            if (result == 0) {
                result = e.id - this.id;
            }
            return result;
        }
    }

    private final class ElementIterator
    implements Iterator {
        private final Iterator m_iterator;

        ElementIterator() {
            this.m_iterator = TreePriorityQueue.this.m_elements.iterator();
        }

        public boolean hasNext() {
            return this.m_iterator.hasNext();
        }

        public Object next() {
            Element e = (Element)this.m_iterator.next();
            return e.object;
        }

        public void remove() {
            this.m_iterator.remove();
        }
    }
}

