/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.queue;

import com.mesquite.queue.PriorityQueue;
import com.mesquite.util.Comparators;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class ListPriorityQueue
implements PriorityQueue {
    private final Comparator m_comparator;
    private final LinkedList m_items = new LinkedList();
    private static final boolean s_debug = false;

    public ListPriorityQueue() {
        this(null);
    }

    public ListPriorityQueue(Comparator comparator) {
        this.m_comparator = comparator != null ? comparator : Comparators.defaultComparator();
    }

    public void clear() {
        this.m_items.clear();
    }

    public boolean add(Object o) {
        ListIterator<Object> it = this.m_items.listIterator();
        while (it.hasNext()) {
            Object old = it.next();
            int result = this.m_comparator.compare(o, old);
            if (result <= 0) continue;
            it.previous();
            break;
        }
        it.add(o);
        return true;
    }

    public Object element() {
        if (this.size() == 0) {
            throw new NoSuchElementException("Queue is empty");
        }
        return this.m_items.getFirst();
    }

    public Object lastElement() {
        if (this.size() == 0) {
            throw new NoSuchElementException("Queue is empty");
        }
        return this.m_items.getLast();
    }

    public boolean isEmpty() {
        return this.m_items.isEmpty();
    }

    public Iterator iterator() {
        return this.m_items.iterator();
    }

    public Object peek() {
        if (this.size() == 0) {
            return null;
        }
        return this.element();
    }

    public Object poll() {
        if (this.size() == 0) {
            return null;
        }
        return this.remove();
    }

    public Object remove() {
        if (this.size() == 0) {
            throw new NoSuchElementException("Queue is empty");
        }
        return this.m_items.removeFirst();
    }

    public boolean remove(Object o) {
        return this.m_items.remove(o);
    }

    public void replace(Object from, Object to) {
        int index = this.m_items.indexOf(from);
        this.m_items.remove(index);
        this.m_items.add(index, to);
    }

    public int size() {
        return this.m_items.size();
    }
}

