/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.queue;

import com.mesquite.queue.PriorityQueue;
import com.mesquite.util.Comparators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class HeapPriorityQueue
implements PriorityQueue {
    private final Comparator m_comparator;
    private ArrayList m_elements;
    private final int m_minCapacity;
    private int m_nextElementId = 0;
    private final Map m_obj2element = new HashMap();
    private boolean m_sorted;
    private static final boolean s_debug = false;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.mesquite.queue.HeapPriorityQueue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public HeapPriorityQueue() {
        this(0, null);
    }

    public HeapPriorityQueue(int initialCapacity) {
        this(initialCapacity, null);
    }

    public HeapPriorityQueue(Comparator comparator) {
        this(0, comparator);
    }

    public HeapPriorityQueue(int initialCapacity, Comparator comparator) {
        this.m_minCapacity = initialCapacity;
        this.m_elements = new ArrayList(initialCapacity);
        this.m_sorted = true;
        this.m_comparator = comparator != null ? comparator : Comparators.defaultComparator();
    }

    public boolean add(Object o) {
        Element newElement = new Element(o, this.m_nextElementId);
        ++this.m_nextElementId;
        this.grow(newElement);
        this.m_obj2element.put(o, newElement);
        this.sanityCheck();
        return true;
    }

    public void clear() {
        this.m_elements.clear();
    }

    public Object element() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Queue is empty");
        }
        Element element = (Element)this.m_elements.get(0);
        return element.object;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object lastElement() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Queue is empty");
        }
        Element element = (Element)this.m_elements.get(this.size() - 1);
        return element.object;
    }

    public Iterator iterator() {
        if (!this.m_sorted) {
            Collections.sort(this.m_elements, Comparators.reverseComparator());
            int i = 0;
            while (i < this.m_elements.size()) {
                Element e = (Element)this.m_elements.get(i);
                e.index = i;
                ++i;
            }
            this.m_sorted = true;
        }
        return new ElementIterator();
    }

    public Object peek() {
        if (this.isEmpty()) {
            return null;
        }
        return this.element();
    }

    public Object poll() {
        if (this.isEmpty()) {
            return null;
        }
        return this.remove();
    }

    public Object remove() {
        Element last;
        Element result = (Element)this.m_elements.get(0);
        if (result != (last = this.shrink())) {
            this.fillHole(0, last);
        }
        this.m_obj2element.remove(result.object);
        this.sanityCheck();
        return result.object;
    }

    public boolean remove(Object o) {
        Element element = (Element)this.m_obj2element.get(o);
        if (element == null) {
            return false;
        }
        Element last = this.shrink();
        if (element != last) {
            this.fillHole(element.index, last);
        }
        this.m_obj2element.remove(element.object);
        this.sanityCheck();
        return true;
    }

    public void replace(Object from, Object to) {
        Element element = (Element)this.m_obj2element.get(from);
        element.object = to;
        this.fillHole(element.index, element);
        this.m_obj2element.remove(from);
        this.m_obj2element.put(to, element);
        this.sanityCheck();
    }

    public int size() {
        return this.m_elements.size();
    }

    private void assign(int index, Element element) {
        this.m_elements.set(index, element);
        element.index = index;
    }

    private Element bestChild(int index) {
        Element child = null;
        int leftIndex = HeapPriorityQueue.leftChildIndex(index);
        if (leftIndex < this.size()) {
            Element rightChild;
            child = (Element)this.m_elements.get(leftIndex);
            int rightIndex = HeapPriorityQueue.rightChildIndex(index);
            if (rightIndex < this.size() && (rightChild = (Element)this.m_elements.get(rightIndex)).compareTo(child) > 0) {
                child = rightChild;
            }
        }
        return child;
    }

    private void grow(Element newElement) {
        this.m_elements.add(null);
        this.fillHole(this.m_elements.size() - 1, newElement);
    }

    private Element shrink() {
        if (!$assertionsDisabled && this.isEmpty()) {
            throw new AssertionError();
        }
        return (Element)this.m_elements.remove(this.size() - 1);
    }

    private void fillHole(int hole, Element node) {
        Element child;
        while (hole > 0) {
            int parentIndex = HeapPriorityQueue.parentIndex(hole);
            Element parent = (Element)this.m_elements.get(parentIndex);
            if (node.compareTo(parent) <= 0) break;
            this.assign(hole, parent);
            hole = parentIndex;
            this.m_sorted = false;
        }
        while ((child = this.bestChild(hole)) != null && node.compareTo(child) < 0) {
            int oldIndex = child.index;
            this.assign(hole, child);
            hole = oldIndex;
            this.m_sorted = false;
        }
        this.assign(hole, node);
    }

    private void sanityCheck() {
    }

    private static int parentIndex(int index) {
        return (index - 1) / 2;
    }

    private static int leftChildIndex(int index) {
        return index * 2 + 1;
    }

    private static int rightChildIndex(int index) {
        return index * 2 + 2;
    }

    private final class Element
    implements Comparable {
        private Object object;
        private final int id;
        private int index = -1;

        public Element(Object o, int id) {
            this.object = o;
            this.id = id;
        }

        public int compareTo(Object o) {
            Element other = (Element)o;
            int result = HeapPriorityQueue.this.m_comparator.compare(this.object, other.object);
            if (result == 0) {
                result = other.id - this.id;
            }
            return result;
        }
    }

    private final class ElementIterator
    implements Iterator {
        private final Iterator m_iterator;

        ElementIterator() {
            this.m_iterator = HeapPriorityQueue.this.m_elements.iterator();
        }

        public boolean hasNext() {
            return this.m_iterator.hasNext();
        }

        public Object next() {
            Element e = (Element)this.m_iterator.next();
            return e.object;
        }

        public void remove() {
            this.m_iterator.remove();
        }
    }
}

