/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.csim.status;

import com.mesquite.csim.Facility;
import com.mesquite.csim.Server;
import com.mesquite.csim.status.QueueStatus;
import com.mesquite.csim.status.Status;
import com.mesquite.text.Format;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;

public class FacilityStatus
implements Status {
    public boolean status(PrintStream s, List objects) {
        if (objects.isEmpty()) {
            return false;
        }
        s.println("STATUS OF FACILITIES");
        s.println();
        s.println("                busy     queue");
        s.println("name.id        servers   length        processes");
        s.println("--------------------------------------------------------------------------------");
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Facility f = (Facility)it.next();
            this.status(s, f);
        }
        s.println();
        return true;
    }

    public void status(PrintStream s, Facility f) {
        Format.printf(s, "%-13.13s  %2d of %1d   %4d    serv:", new Object[]{String.valueOf(f.name()) + "." + f.identity(), new Integer(f.num_busy()), new Integer(f.num_servers()), new Integer(f.qlength())});
        int n = 0;
        int i = 0;
        while (i < f.num_servers()) {
            Server svr = f.server(i);
            String str = svr.process() != null ? String.valueOf(svr.process().name()) + "." + svr.process().identity() : "";
            Format.printf(s, " %-13.13s", new Object[]{str});
            if (i % 3 == 2) {
                s.println();
                n = 0;
            } else {
                ++n;
            }
            ++i;
        }
        if (n > 0) {
            s.println();
        }
        if (!f.getQueue().isEmpty()) {
            s.print("                                queue:");
            QueueStatus.status(s, f.getQueue());
        }
    }

    public void collectClassStats(PrintStream s, List objects) {
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Facility f = (Facility)it.next();
            f.collect();
        }
    }
}

