/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.csim.status;

import com.mesquite.csim.Event;
import com.mesquite.csim.status.QueueStatus;
import com.mesquite.csim.status.Status;
import com.mesquite.text.Format;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;

public class EventStatus
implements Status {
    public boolean status(PrintStream s, List objects) {
        if (objects.isEmpty()) {
            return false;
        }
        s.println("STATUS OF GLOBAL EVENTS");
        s.println();
        s.println("                         counts");
        s.println("name.id        state   wait/queue      processes");
        s.println();
        s.println("--------------------------------------------------------------------------------");
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Event e = (Event)it.next();
            this.report(s, e);
        }
        s.println();
        return true;
    }

    public void report(PrintStream s, Event e) {
        String str = e.occurred() ? "occ" : "!occ";
        Format.printf(s, "%-13.13s   %4s   %4d/%-4d wait:", new Object[]{String.valueOf(e.name()) + "." + e.identity(), str, new Integer(e.wait_cnt()), new Integer(e.queue_cnt())});
        if (e.wait_cnt() > 0) {
            QueueStatus.status(s, e.getWaitQueue());
        } else if (e.queue_cnt() > 0) {
            s.println();
        }
        if (e.queue_cnt() > 0) {
            s.print("                                queue:");
            QueueStatus.status(s, e.getQueueQueue());
        } else {
            s.println();
        }
    }

    public void collectClassStats(PrintStream s, List objects) {
    }
}

