/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.csim.reports;

import com.mesquite.csim.BasicTable;
import com.mesquite.csim.Table;
import com.mesquite.csim.reports.Reporter;
import com.mesquite.text.Format;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;

public class TableReporter
implements Reporter {
    public boolean report(PrintStream s, List args) {
        if (args.isEmpty()) {
            return false;
        }
        Iterator it = args.iterator();
        while (it.hasNext()) {
            Table t = (Table)it.next();
            this.report(s, t);
        }
        return true;
    }

    public void report(PrintStream s, Table t) {
        if (!t.IsBasicTable()) {
            this.reportHeader(s, t);
        }
        TableReporter.reportBody(s, t);
    }

    private void reportHeader(PrintStream s, Table t) {
        s.println("Table " + t.identity() + ": " + t.name());
        s.println();
    }

    public static void reportBody(PrintStream s, BasicTable t) {
        String fmt = "      minimum   %14.6f           mean               %14.6f\n";
        Object[] args = new Object[]{new Double(t.min()), new Double(t.mean())};
        Format.printf(s, fmt, args);
        fmt = "      maximum   %14.6f           variance           %14.6f\n";
        args = new Object[]{new Double(t.max()), new Double(t.var())};
        Format.printf(s, fmt, args);
        fmt = "      range     %14.6f           standard deviation %14.6f\n";
        args = new Object[]{new Double(t.range()), new Double(t.stddev())};
        Format.printf(s, fmt, args);
        fmt = "      observations %11.0f           coefficient of var %14.6f\n";
        args = new Object[]{new Double(t.count()), new Double(t.cv())};
        Format.printf(s, fmt, args);
        s.println();
        if (t.histogram() != null) {
            t.histogram().report(s);
            s.println();
        }
        if (t.getConfidenceInterval() != null) {
            t.getConfidenceInterval().report(s);
            s.println();
        }
    }

    public boolean dump_status(PrintStream s, List args) {
        return true;
    }
}

