/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.csim.reports;

import com.mesquite.csim.Storage;
import com.mesquite.csim.reports.Reporter;
import com.mesquite.text.Format;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;

public class StorageReporter
implements Reporter {
    public boolean report(PrintStream s, List args) {
        if (args.isEmpty()) {
            return false;
        }
        s.println("STORAGE SUMMARY");
        s.println();
        s.println("storage                 alloc alloc dealloc dealloc            in-que  in-queue");
        s.println("name             size  amount count  amount   count    util    length      time");
        s.println("-------------------------------------------------------------------------------");
        Iterator it = args.iterator();
        while (it.hasNext()) {
            Storage st = (Storage)it.next();
            this.report(s, st);
        }
        s.println();
        return true;
    }

    private void report(PrintStream s, Storage st) {
        String fmt = "%-12.12s %8d %7.1f %5d %7.1f %7d %7.3f %9.5f %10.5f";
        Object[] args = new Object[]{st.name(), new Integer(st.capacity()), new Double(st.allocCount() > 0 ? (double)st.sumAllocs() / (double)st.allocCount() : 0.0), new Integer(st.allocCount()), new Double(st.allocCount() > 0 ? (double)st.sumDeallocs() / (double)st.allocCount() : 0.0), new Integer(st.deallocCount()), new Double(st.utilization()), new Double(st.queueLength()), new Double(st.responseTime())};
        s.println(Format.format(fmt, args));
    }

    public boolean dump_status(PrintStream s, List args) {
        return true;
    }
}

