/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.csim.reports;

import com.mesquite.csim.BasicQTable;
import com.mesquite.csim.QTable;
import com.mesquite.csim.reports.Reporter;
import com.mesquite.text.Format;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;

public class QTableReporter
implements Reporter {
    private static final int s_maxBar = 20;

    public boolean report(PrintStream s, List args) {
        if (args.isEmpty()) {
            return false;
        }
        Iterator it = args.iterator();
        while (it.hasNext()) {
            QTable qt = (QTable)it.next();
            this.report(s, qt);
        }
        return true;
    }

    public void report(PrintStream s, QTable qt) {
        if (!qt.IsBasicQTable()) {
            this.reportHeader(s, qt);
        }
        QTableReporter.reportBody(s, qt);
    }

    private void reportHeader(PrintStream s, QTable qt) {
        s.println("QTABLE " + qt.identity() + ":  " + qt.name());
        s.println();
    }

    public static void reportBody(PrintStream s, BasicQTable qt) {
        if (qt.elapsedTime() == 0.0) {
            s.println("      > no time has passed since creation or reset");
            s.println();
            return;
        }
        String fmt = "      initial%8.0f      minimum%8.0f      mean              %14.6f\n";
        Object[] args = new Object[]{new Double(0.0), new Double(qt.min()), new Double(qt.mean())};
        Format.printf(s, fmt, args);
        fmt = "      final  %8.0f      maximum%8.0f      variance          %14.6f\n";
        args = new Object[]{new Double(qt.current()), new Double(qt.max()), new Double(qt.var())};
        Format.printf(s, fmt, args);
        fmt = "      entries%8.0f      range  %8.0f      standard deviation%14.6f\n";
        args = new Object[]{new Double(qt.entries()), new Double(qt.range()), new Double(qt.stddev())};
        Format.printf(s, fmt, args);
        fmt = "      exits  %8.0f                           coeff of variation%14.6f\n";
        args = new Object[]{new Double(qt.exits()), new Double(qt.cv())};
        Format.printf(s, fmt, args);
        if (qt.histogram() != null) {
            QTableReporter.reportHistogram(s, qt);
        }
        if (qt.getConfidenceInterval() != null) {
            qt.getConfidenceInterval().report(s);
        }
    }

    private static void reportHistogram(PrintStream s, BasicQTable qt) {
        double maxProportion;
        if (qt.hist_total() > 0.0) {
            double fullest = 0.0;
            int i = 0;
            while ((long)i <= qt.hist_num() + 1L) {
                double val = qt.hist_bucket(i);
                if (val > fullest) {
                    fullest = val;
                }
                ++i;
            }
            maxProportion = fullest / qt.hist_total();
        } else {
            maxProportion = 0.0;
        }
        int startBucket = 0;
        int stopBucket = (int)qt.hist_num() + 1;
        double x = 0.0;
        while (startBucket <= stopBucket && (x = qt.hist_bucket(startBucket)) == 0.0) {
            ++startBucket;
        }
        while (stopBucket >= startBucket && qt.hist_bucket(stopBucket) == 0.0) {
            --stopBucket;
        }
        if (startBucket == stopBucket && (long)stopBucket <= qt.hist_num()) {
            ++stopBucket;
        }
        s.println("                                                  cumulative");
        s.println("           lower limit     frequency   proportion proportion");
        double cumulative = 0.0;
        int i = startBucket;
        while (i <= stopBucket) {
            double key;
            String prefix;
            double proportion = qt.hist_total() > 0.0 ? qt.hist_bucket(i) / qt.hist_total() : 0.0;
            double frequency = qt.hist_bucket(i);
            cumulative += proportion;
            if (i == 0) {
                prefix = "<";
                key = qt.hist_low();
            } else if ((long)i == qt.hist_num() + 1L) {
                prefix = ">=";
                key = qt.hist_high();
            } else {
                prefix = "";
                key = qt.hist_low() + (double)i * qt.hist_width();
            }
            Format.printf(s, "%5s      %11.5f      %8.1f     %8.6f  %8.6f ", new Object[]{prefix, new Double(key), new Double(frequency), new Double(proportion), new Double(cumulative)});
            int barLength = maxProportion > 0.0 ? (int)Math.floor(proportion / maxProportion * 20.0 + 0.499999) : 0;
            if (barLength == 0 && proportion > 0.0) {
                s.print(".");
            } else {
                int j = 0;
                while (j < barLength) {
                    s.print("*");
                    ++j;
                }
            }
            s.println();
            ++i;
        }
        s.println();
    }

    public boolean dump_status(PrintStream s, List args) {
        return true;
    }
}

