/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.csim.reports;

import com.mesquite.csim.ProcessClass;
import com.mesquite.csim.reports.Reporter;
import com.mesquite.text.Format;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;

public class ProcessClassReporter
implements Reporter {
    public boolean report(PrintStream s, List args) {
        if (args.isEmpty() || args.size() < 2) {
            return false;
        }
        ProcessClassReporter.reportHeader(s);
        Iterator it = args.iterator();
        while (it.hasNext()) {
            ProcessClass pc = (ProcessClass)it.next();
            this.report(s, pc);
        }
        s.println();
        return true;
    }

    public boolean dump_status(PrintStream s, List args) {
        return true;
    }

    public void report(PrintStream s, ProcessClass pc) {
        int number = pc.count();
        double avgLifeTime = number > 0 ? pc.lifetime() / (double)number : 0.0;
        double avgHoldCount = number > 0 ? (double)pc.holdCount() / (double)number : 0.0;
        double avgHoldTime = number > 0 ? pc.holdTime() / (double)number : 0.0;
        double avgWaitTime = avgLifeTime - avgHoldTime;
        String fmt = "%3d  %-15s  %5d %12.5f %12.5f %12.5f %12.5f";
        Object[] args = new Object[]{new Integer(pc.identity()), pc.name(), new Integer(number), new Double(avgLifeTime), new Double(avgHoldCount), new Double(avgHoldTime), new Double(avgWaitTime)};
        s.println(Format.format(fmt, args));
    }

    private static void reportHeader(PrintStream s) {
        s.println("PROCESS CLASS SUMMARY");
        s.println("");
        s.println(" id  name            number     lifetime   hold count    hold time    wait time ");
        s.println("--------------------------------------------------------------------------------");
    }
}

