/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.csim.reports;

import com.mesquite.csim.Mailbox;
import com.mesquite.csim.reports.Reporter;
import com.mesquite.text.Format;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;

public class MailboxReporter
implements Reporter {
    public boolean report(PrintStream s, List args) {
        Mailbox m;
        if (args.isEmpty()) {
            return false;
        }
        int numReports = 0;
        Iterator it = args.iterator();
        while (it.hasNext()) {
            m = (Mailbox)it.next();
            if (!m.reportEnabled()) continue;
            ++numReports;
        }
        if (numReports > 0) {
            s.println("MAILBOX SUMMARY");
            s.println();
            s.println("mailbox    number of     process    process  number of     message    message");
            s.println("name      proc visits    qlength    rspTime  messages      qlength    rspTime");
            s.println("-----------------------------------------------------------------------------");
            it = args.iterator();
            while (it.hasNext()) {
                m = (Mailbox)it.next();
                this.report(s, m);
            }
        }
        return true;
    }

    private void report(PrintStream s, Mailbox m) {
        String fmt = "%-10s %10d %10.5f %10.5f   %8d  %10.5f %10.5f";
        Object[] args = new Object[]{m.name(), new Integer(m.proc_count()), new Double(m.proc_length()), new Double(m.proc_time()), new Integer(m.msg_count()), new Double(m.msg_length()), new Double(m.msg_time())};
        s.println(Format.format(fmt, args));
    }

    public boolean dump_status(PrintStream s, List args) {
        return true;
    }
}

