/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.csim.reports;

import com.mesquite.csim.Facility;
import com.mesquite.csim.FacilityStats;
import com.mesquite.csim.ProcessClass;
import com.mesquite.csim.ServerStats;
import com.mesquite.csim.reports.Reporter;
import com.mesquite.text.Format;
import java.io.PrintStream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class FacilityReporter
implements Reporter {
    public boolean report(PrintStream out, List args) {
        if (args.isEmpty()) {
            return false;
        }
        out.println("FACILITY SUMMARY");
        out.println();
        out.println("facility     service    service          through-    queue     response   compl");
        out.println("name           disc      time    util.     put       length       time    count");
        out.println("--------------------------------------------------------------------------------");
        Iterator it = args.iterator();
        while (it.hasNext()) {
            Facility fac = (Facility)it.next();
            this.report(out, fac);
        }
        out.println();
        return true;
    }

    private void report(PrintStream out, Facility fac) {
        FacilityStats stats = fac.stats();
        String fmt = "%-12.12s %-7.7s %10.5f %6.3f %10.5f %10.5f %10.5f %8d";
        Object[] args = new Object[]{fac.name(), fac.type(), new Double(stats.serviceTime()), new Double(stats.utilization()), new Double(stats.throughput()), new Double(stats.queueLength()), new Double(stats.responseTime()), new Integer(stats.completions())};
        out.println(Format.format(fmt, args));
        if (fac.numServers() > 1) {
            int i = 0;
            while (i < fac.numServers()) {
                ServerStats stats2 = fac.serverStats(i);
                String fmt2 = "   > server %2d       %10.5f %6.3f %10.5f                       %8d";
                Object[] args2 = new Object[]{new Integer(i), new Double(stats2.serviceTime()), new Double(stats2.utilization()), new Double(stats2.throughput()), new Integer(stats2.completions())};
                out.println(Format.format(fmt2, args2));
                ++i;
            }
        }
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                ProcessClass c1 = (ProcessClass)o1;
                ProcessClass c2 = (ProcessClass)o2;
                return c1.identity() - c2.identity();
            }
        };
        TreeSet classes = new TreeSet(c);
        classes.addAll(fac.processClasses());
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            ProcessClass cl = (ProcessClass)it.next();
            FacilityStats stats3 = fac.stats(cl);
            String fmt3 = "   > class %-10.10s%10.5f %6.3f %10.5f %10.5f %10.5f %8d";
            Object[] args3 = new Object[]{stats3.processClass().name(), new Double(stats3.serviceTime()), new Double(stats3.utilization()), new Double(stats3.throughput()), new Double(stats3.queueLength()), new Double(stats3.responseTime()), new Integer(stats3.completions())};
            out.println(Format.format(fmt3, args3));
        }
    }

    public boolean dump_status(PrintStream out, List args) {
        if (args.isEmpty()) {
            return false;
        }
        out.println("STATUS OF FACILITIES");
        out.println();
        out.println("                busy     queue");
        out.println("name.id        servers   length        processes");
        out.println("--------------------------------------------------------------------------");
        Iterator it = args.iterator();
        while (it.hasNext()) {
            Facility fac = (Facility)it.next();
            fac.dumpStatus(out);
        }
        out.println();
        return true;
    }
}

