/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.csim.reports;

import com.mesquite.csim.Event;
import com.mesquite.csim.reports.Reporter;
import com.mesquite.text.Format;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;

public class EventReporter
implements Reporter {
    public boolean report(PrintStream s, List args) {
        Event ev;
        if (args.isEmpty()) {
            return false;
        }
        int numReports = 0;
        Iterator it = args.iterator();
        while (it.hasNext()) {
            ev = (Event)it.next();
            if (!ev.reportEnabled()) continue;
            ++numReports;
        }
        if (numReports > 0) {
            s.println("EVENT SUMMARY");
            s.println();
            s.println("event      number of   avg que  avg time number of  avg wait  avg time number of");
            s.println("name       queue vst   length    queued  wait vsts   length   waiting   set ops ");
            s.println("--------------------------------------------------------------------------------");
            it = args.iterator();
            while (it.hasNext()) {
                ev = (Event)it.next();
                if (!ev.reportEnabled()) continue;
                this.report(s, ev);
            }
            s.println();
        }
        return true;
    }

    private void report(PrintStream s, Event ev) {
        String fmt = "%-10s %9d%10.5f%10.5f %9d%10.5f%10.5f %9d";
        Object[] args = new Object[]{ev.name(), new Integer(ev.queue_visits()), new Double(ev.queue_len()), new Double(ev.queue_time()), new Integer(ev.wait_visits()), new Double(ev.wait_len()), new Double(ev.wait_time()), new Integer(ev.num_sets())};
        s.println(Format.format(fmt, args));
    }

    public boolean dump_status(PrintStream s, List args) {
        return true;
    }
}

