/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.csim.reports;

import com.mesquite.csim.Buffer;
import com.mesquite.csim.reports.Reporter;
import com.mesquite.text.Format;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;

public class BufferReporter
implements Reporter {
    public boolean report(PrintStream s, List args) {
        if (args.isEmpty()) {
            return false;
        }
        s.println("BUFFER SUMMARY");
        s.println();
        s.println("buffer                 get      get      get   get   put      put      put   put");
        s.println("name            size   amt     qlen     resp count   amt     qlen     resp count");
        s.println("--------------------------------------------------------------------------------");
        Iterator it = args.iterator();
        while (it.hasNext()) {
            Buffer b = (Buffer)it.next();
            this.report(s, b);
        }
        s.println();
        return true;
    }

    private void report(PrintStream s, Buffer b) {
        String fmt = "%-12.12s%8d %5.1f %8.5f %8.5f %5d %5.1f %8.5f %8.5f %5d";
        Object[] args = new Object[]{b.name(), new Integer(b.size()), new Double(b.get_amount()), new Double(b.get_queueLength()), new Double(b.get_responseTime()), new Integer(b.get_count()), new Double(b.put_amount()), new Double(b.put_queueLength()), new Double(b.put_responseTime()), new Integer(b.put_count())};
        s.println(Format.format(fmt, args));
    }

    public boolean dump_status(PrintStream out, List args) {
        return true;
    }
}

