/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.csim.registry;

import com.mesquite.csim.Resource;
import com.mesquite.csim.classStats.ClassStats;
import com.mesquite.csim.registry.Counter;
import com.mesquite.csim.registry.Group;
import com.mesquite.csim.reports.Reporter;
import com.mesquite.csim.status.Status;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ResourceGroup
implements Group {
    private final List m_objects = new LinkedList();
    private final Counter m_counter;
    private Reporter m_reporter;
    private Status m_statusDumper;
    private ClassStats m_collectClassStats;

    protected ResourceGroup(Reporter reporter, Status statusDumper, ClassStats classStats, Counter counter) {
        this.m_reporter = reporter;
        this.m_statusDumper = statusDumper;
        this.m_collectClassStats = classStats;
        this.m_counter = counter;
    }

    public int add(Object o) {
        this.m_objects.add(o);
        return this.m_counter.next();
    }

    public void report(PrintStream s) {
        this.m_reporter.report(s, this.m_objects);
    }

    public void reset() {
        Iterator it = this.m_objects.iterator();
        while (it.hasNext()) {
            Resource r = (Resource)it.next();
            r.reset();
        }
    }

    public void start() {
        this.m_objects.clear();
    }

    public void status(PrintStream s) {
        this.m_statusDumper.status(s, this.m_objects);
    }

    public void classStats() {
        this.m_collectClassStats.classStats(this.m_objects);
    }

    public void stop() {
    }
}

