/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.csim.registry;

import com.mesquite.csim.registry.Group;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Registry {
    private final List m_names = new LinkedList();
    private final Map m_name2group = new HashMap();

    public int add(String name, Object r) {
        Group g = (Group)this.m_name2group.get(name);
        if (g == null) {
            throw new RuntimeException("Group does not exist");
        }
        return g.add(r);
    }

    public void addGroup(String name, Group group) {
        Group result = this.m_name2group.put(name, group);
        if (result == null) {
            this.m_names.add(name);
        }
    }

    public void report(PrintStream s) {
        Iterator it = this.m_names.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            this.reportGroup(name, s);
        }
    }

    public void reportGroup(String name, PrintStream s) {
        Group g = (Group)this.m_name2group.get(name);
        g.report(s);
    }

    public void reset() {
        Iterator it = this.m_name2group.values().iterator();
        while (it.hasNext()) {
            Group g = (Group)it.next();
            g.reset();
        }
    }

    public void start() {
        Iterator it = this.m_name2group.values().iterator();
        while (it.hasNext()) {
            Group g = (Group)it.next();
            g.start();
        }
    }

    public void status(PrintStream s) {
        Iterator it = this.m_names.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            this.statusGroup(name, s);
        }
    }

    public void statusGroup(String name, PrintStream s) {
        Group g = (Group)this.m_name2group.get(name);
        g.status(s);
    }

    public void collectClassStats(PrintStream s) {
        Group g = (Group)this.m_name2group.get("facility");
        g.classStats();
    }

    public void stop() {
        Iterator it = this.m_name2group.values().iterator();
        while (it.hasNext()) {
            Group g = (Group)it.next();
            g.stop();
        }
    }
}

