/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.csim;

import java.security.spec.KeySpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class StringEncrypter {
    private KeySpec keySpec;
    private SecretKeyFactory keyFactory;
    private Cipher cipher;

    public StringEncrypter(String encryptionKey) throws Exception {
        if (encryptionKey == null) {
            throw new IllegalArgumentException("encryption key was null");
        }
        if (encryptionKey.trim().length() < 24) {
            throw new IllegalArgumentException("encryption key was fewer than than 24 characters");
        }
        byte[] keyAsBytes = encryptionKey.getBytes("UTF8");
        this.keySpec = new DESKeySpec(keyAsBytes);
        this.keyFactory = SecretKeyFactory.getInstance("DES");
        this.cipher = Cipher.getInstance("DES");
    }

    public String encrypt(String unencryptedString) throws Exception {
        if (unencryptedString == null || unencryptedString.trim().length() == 0) {
            throw new IllegalArgumentException("unencrypted string was null or empty");
        }
        SecretKey key = this.keyFactory.generateSecret(this.keySpec);
        this.cipher.init(1, key);
        byte[] cleartext = unencryptedString.getBytes("UTF8");
        byte[] ciphertext = this.cipher.doFinal(cleartext);
        BASE64Encoder base64encoder = new BASE64Encoder();
        return base64encoder.encode(ciphertext);
    }

    public String decrypt(String encryptedString) throws Exception {
        if (encryptedString == null || encryptedString.trim().length() <= 0) {
            throw new IllegalArgumentException("encrypted string was null or empty");
        }
        SecretKey key = this.keyFactory.generateSecret(this.keySpec);
        this.cipher.init(2, key);
        BASE64Decoder base64decoder = new BASE64Decoder();
        byte[] cleartext = base64decoder.decodeBuffer(encryptedString);
        byte[] ciphertext = this.cipher.doFinal(cleartext);
        return StringEncrypter.bytes2String(ciphertext);
    }

    private static String bytes2String(byte[] bytes) {
        StringBuffer stringBuffer = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            stringBuffer.append((char)bytes[i]);
            ++i;
        }
        return stringBuffer.toString();
    }
}

