/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.csim;

import com.mesquite.csim.AbstractResource;
import com.mesquite.csim.Model;
import com.mesquite.csim.Process;
import com.mesquite.csim.ProcessQueue;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Storage
extends AbstractResource {
    private int m_capacity;
    private int m_available;
    private final ProcessQueue m_waitQueue;
    private double m_lastChangeTime;
    private double m_busySum;
    private int m_sumAllocs;
    private int m_allocCount;
    private int m_sumDeallocs;
    private int m_deallocCount;
    private double m_startTime;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.mesquite.csim.Storage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public Storage(String name, int capacity) {
        this(name, capacity, Model.currentModel());
    }

    public Storage(String name, int capacity, Model model) {
        super("storage", name, model);
        this.m_capacity = capacity;
        this.m_waitQueue = new ProcessQueue();
        this.m_available = this.m_capacity;
        this.m_lastChangeTime = this.model().clock();
        this.reset();
        if (this.model().traceEnabled()) {
            Process p = this.model().getActiveProcess();
            String str = "init storage " + this.name() + " capacity " + String.valueOf(this.m_capacity);
            this.model().traceEvent(p, str);
        }
    }

    public void collect() {
    }

    public void allocate(int amt) {
        this.model().checkThread();
        Process p = this.model().getActiveProcess();
        if (this.model().traceEnabled()) {
            String strAvail = String.valueOf(this.m_available);
            String strAmt = String.valueOf(amt);
            this.model().traceEvent("allocate " + this.name() + " avail " + strAvail + " amt " + strAmt);
        }
        this.xallocate(p, amt);
    }

    public void deallocate(int amt) {
        this.model().checkThread();
        Process p = this.model().getActiveProcess();
        if (this.model().traceEnabled()) {
            String strAvail = String.valueOf(this.m_available);
            String strAmt = String.valueOf(amt);
            this.model().traceEvent("deallocate " + this.name() + " avail " + strAvail + " amt " + strAmt);
        }
        this.xdeallocate(p, amt);
    }

    public boolean timed_allocate(int amt, double timeout) {
        boolean result;
        Process p = this.model().getActiveProcess();
        this.model().checkThread();
        if (this.model().traceEnabled()) {
            String str = Model.s_timeFormat.format(timeout);
            this.model().traceEvent("timed allocate: " + this.name() + " " + String.valueOf(amt) + " " + str);
        }
        this.model().schedule(timeout);
        this.xallocate(p, amt);
        if (p.queue() != null) {
            if (!$assertionsDisabled && this.model().hasEvent(p)) {
                throw new AssertionError();
            }
            if (this.model().traceEnabled()) {
                this.model().traceEvent("timed out at " + this.name());
            }
            this.m_waitQueue.remove(p);
            result = false;
        } else {
            if (this.model().traceEnabled()) {
                this.model().traceEvent("timed_alloc got " + this.name());
            }
            if (this.model().hasEvent(p)) {
                this.model().cancel(p);
            }
            result = true;
        }
        return result;
    }

    public double elapsedTime() {
        return this.model().clock() - this.m_startTime;
    }

    public int capacity() {
        return this.m_capacity;
    }

    public int qlength() {
        return this.m_waitQueue.size();
    }

    public int available() {
        return this.m_available;
    }

    public double busySum() {
        return this.m_busySum;
    }

    public double waitingTime() {
        return this.m_waitQueue.waitTime();
    }

    public int sumAllocs() {
        return this.m_sumAllocs;
    }

    public int sumDeallocs() {
        return this.m_sumDeallocs;
    }

    public int allocCount() {
        return this.m_allocCount;
    }

    public int deallocCount() {
        return this.m_deallocCount;
    }

    public double utilization() {
        if (this.elapsedTime() * (double)this.capacity() > 0.0) {
            return this.busySum() / (this.elapsedTime() * (double)this.capacity());
        }
        return 0.0;
    }

    public double queueLength() {
        if (this.elapsedTime() > 0.0) {
            return this.waitingTime() / this.elapsedTime();
        }
        return 0.0;
    }

    public double responseTime() {
        if (this.allocCount() > 0) {
            return this.waitingTime() / (double)this.allocCount();
        }
        return 0.0;
    }

    public void reset() {
        this.m_busySum = 0.0;
        this.m_sumAllocs = 0;
        this.m_allocCount = 0;
        this.m_sumDeallocs = 0;
        this.m_deallocCount = 0;
        this.m_startTime = this.model().clock();
        this.m_waitQueue.reset();
    }

    public ProcessQueue getQueue() {
        return this.m_waitQueue;
    }

    public Process first_process() {
        if (!this.m_waitQueue.isEmpty()) {
            return this.m_waitQueue.peek();
        }
        return null;
    }

    public Process last_process() {
        if (!this.m_waitQueue.isEmpty()) {
            return this.m_waitQueue.lastProcess();
        }
        return null;
    }

    public Process remove_process(Process pr) {
        if (!this.m_waitQueue.isEmpty()) {
            this.m_waitQueue.remove(pr);
            if (this.model().traceEnabled()) {
                this.model().traceEvent("remove " + pr.name() + "." + pr.identity());
            }
            return pr;
        }
        return null;
    }

    public void insert_process(Process pr) {
        if (this.model().traceEnabled()) {
            this.model().traceEvent("insert " + pr.name() + "." + pr.identity());
        }
        this.m_waitQueue.add(pr);
    }

    public List process_list() {
        LinkedList<Process> pList = new LinkedList<Process>();
        while (!this.m_waitQueue.isEmpty()) {
            pList.add(this.m_waitQueue.remove());
        }
        Iterator it = pList.iterator();
        while (it.hasNext()) {
            this.m_waitQueue.add((Process)it.next());
        }
        return pList;
    }

    protected void xallocate(int amt) {
        Process p = this.model().getActiveProcess();
        this.xallocate(p, amt);
    }

    protected void xallocate(Process p, int amt) {
        if (amt > this.m_capacity) {
            throw new RuntimeException("storage: allocate amt > capacity");
        }
        p.storageRequest = amt;
        if (!this.m_waitQueue.isEmpty() && p.priority() <= this.m_waitQueue.peek().priority()) {
            this.m_waitQueue.add(p);
            if (p.thread() == Thread.currentThread()) {
                p.suspendAndFire();
            }
            return;
        }
        int thisAmt = p.storageRequest;
        if (this.m_available < thisAmt) {
            this.m_waitQueue.add(p);
            if (p.thread() == Thread.currentThread()) {
                p.suspendAndFire();
            }
            return;
        }
        thisAmt = p.storageRequest;
        this.updateAllocStats(thisAmt);
        this.m_available -= thisAmt;
    }

    protected void updateAllocStats(int amt) {
        this.m_sumAllocs += amt;
        ++this.m_allocCount;
        this.m_busySum += (double)(this.m_capacity - this.m_available) * (this.model().clock() - this.m_lastChangeTime);
        this.m_lastChangeTime = this.model().clock();
    }

    protected void xdeallocate(int amt) {
        Process p = this.model().getActiveProcess();
        this.xdeallocate(p, amt);
    }

    protected void xdeallocate(Process p, int amt) {
        if (amt + this.m_available > this.m_capacity) {
            throw new RuntimeException("storage: deallocate amt + available > capacity");
        }
        this.updateDeallocStats(amt);
        this.m_available += amt;
        while (!this.m_waitQueue.isEmpty() && this.m_available > 0 && this.m_waitQueue.peek().storageRequest <= this.m_available) {
            Process next = this.m_waitQueue.remove();
            int thisAmt = next.storageRequest;
            if (this.model().traceEnabled()) {
                String strAvail = String.valueOf(this.m_available);
                String strAmt = String.valueOf(thisAmt);
                this.model().traceEvent(next, "allocate1 " + next.name() + " avail " + strAvail + " amt " + strAmt);
            }
            this.updateAllocStats(thisAmt);
            this.m_available -= thisAmt;
            if (next.queue() != null) {
                next.queue().remove(next);
            } else if (this.model().hasEvent(next)) {
                this.model().cancel(next);
            }
            this.model().schedule(0.0, next);
        }
    }

    protected void updateDeallocStats(int amt) {
        this.m_busySum += (double)(this.m_capacity - this.m_available) * (this.model().clock() - this.m_lastChangeTime);
        this.m_lastChangeTime = this.model().clock();
        this.m_sumDeallocs += amt;
        ++this.m_deallocCount;
    }
}

