/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.csim;

import com.mesquite.csim.Facility;
import com.mesquite.csim.Process;
import com.mesquite.csim.ProcessClass;
import com.mesquite.csim.ServerStats;
import java.util.HashMap;
import java.util.Map;

public class Server {
    private final Facility m_fac;
    private final int m_index;
    private Process m_process = null;
    private double m_busyStart;
    private double m_resetTime;
    private final Stats m_stats = new Stats(null);
    private Map m_classStats = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.mesquite.csim.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public Server(Facility facility, int index) {
        this.m_fac = facility;
        this.m_index = index;
        this.reset();
    }

    public void assign(Process p) {
        if (!$assertionsDisabled && this.m_process != null) {
            throw new AssertionError();
        }
        this.m_process = p;
        this.m_busyStart = this.m_fac.model().clock();
    }

    public void collect() {
        if (this.m_classStats == null) {
            this.m_classStats = new HashMap();
        }
    }

    public int index() {
        return this.m_index;
    }

    public boolean isBusy() {
        return this.m_process != null;
    }

    public Process process() {
        return this.m_process;
    }

    public void release() {
        if (!$assertionsDisabled && this.m_process == null) {
            throw new AssertionError();
        }
        double clock = this.m_fac.model().clock();
        double busyInterval = clock - this.m_busyStart;
        Stats stats = this.m_stats;
        stats.m_busyTotal = stats.m_busyTotal + busyInterval;
        Stats stats2 = this.m_stats;
        stats2.m_completions = stats2.m_completions + 1;
        if (this.m_classStats != null) {
            ProcessClass cl = this.m_process.getProcessClass();
            Stats classStats = (Stats)this.m_classStats.get(cl);
            if (classStats == null) {
                classStats = new Stats(cl);
                this.m_classStats.put(this.m_process.getProcessClass(), classStats);
            }
            Stats stats3 = classStats;
            stats3.m_busyTotal = stats3.m_busyTotal + busyInterval;
            Stats stats4 = classStats;
            stats4.m_completions = stats4.m_completions + 1;
        }
        this.m_process = null;
    }

    public void reset() {
        this.m_resetTime = this.m_fac.model().clock();
        this.m_stats.m_busyTotal = 0.0;
        this.m_stats.m_completions = 0;
    }

    public ServerStats stats() {
        return this.m_stats;
    }

    public ServerStats stats(ProcessClass cl) {
        ServerStats stats = (ServerStats)this.m_classStats.get(cl);
        if (stats != null) {
            return stats;
        }
        return new Stats(cl);
    }

    private final class Stats
    implements ServerStats {
        private int m_completions;
        private double m_busyTotal;
        private final ProcessClass m_processClass;

        Stats(ProcessClass cl) {
            this.m_processClass = cl;
        }

        public int completions() {
            return this.m_completions;
        }

        public double elapsedTime() {
            return Server.this.m_fac.model().clock() - Server.this.m_resetTime;
        }

        public ProcessClass processClass() {
            return this.m_processClass;
        }

        public double serviceTime() {
            if (this.completions() > 0) {
                return this.busyTime() / (double)this.completions();
            }
            return 0.0;
        }

        public double throughput() {
            if (this.elapsedTime() > 0.0) {
                return (double)this.completions() / this.elapsedTime();
            }
            return 0.0;
        }

        public double utilization() {
            if (this.elapsedTime() > 0.0) {
                return this.busyTime() / this.elapsedTime();
            }
            return 0.0;
        }

        private double busyTime() {
            if (Server.this.m_process == null) {
                return this.m_busyTotal;
            }
            if (this.m_processClass != null && Server.this.m_process.getProcessClass() != this.m_processClass) {
                return this.m_busyTotal;
            }
            return this.m_busyTotal + (Server.this.m_fac.model().clock() - Server.this.m_busyStart);
        }
    }
}

