/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.csim;

import com.mesquite.csim.OldRandom;

public class Random
extends java.util.Random {
    private java.util.Random m_random;

    public Random() {
        this(new OldRandom());
    }

    public Random(long seed) {
        this(new OldRandom(seed));
    }

    public Random(java.util.Random r) {
        this.m_random = r;
    }

    public void set(java.util.Random r) {
        this.m_random = r;
    }

    public boolean nextBoolean() {
        return this.m_random.nextBoolean();
    }

    public void nextBytes(byte[] bytes) {
        this.m_random.nextBytes(bytes);
    }

    public double nextDouble() {
        return this.m_random.nextDouble();
    }

    public float nextFloat() {
        return this.m_random.nextFloat();
    }

    public double nextGaussian() {
        return this.m_random.nextGaussian();
    }

    public int nextInt() {
        return this.m_random.nextInt();
    }

    public int nextInt(int n) {
        return this.m_random.nextInt(n);
    }

    public long nextLong() {
        return this.m_random.nextLong();
    }

    public void setSeed(long seed) {
        if (this.m_random != null) {
            this.m_random.setSeed(seed);
        }
    }

    public double erlang(double mean, double var) {
        int k = (int)Math.floor(mean * mean / var + 0.5);
        k = k > 0 ? k : 1;
        double a = (double)k / mean;
        double prod = 1.0;
        int i = 1;
        while (i <= k) {
            prod *= this.m_random.nextDouble();
            ++i;
        }
        double y = -Math.log(prod) / a;
        return y;
    }

    public double exponential(double mean) {
        double x = this.m_random.nextDouble();
        return -mean * Math.log(x);
    }

    public double hyperexponential(double mean, double var) {
        return this.hyperx(mean, var);
    }

    public double hyperx(double mean, double var) {
        double z = var / (mean * mean);
        if (z <= 1.0) {
            throw new RuntimeException("hyperexponential: var < mean*mean");
        }
        double p = 0.5 * (1.0 - Math.sqrt((z - 1.0) / (z + 1.0)));
        double d = this.m_random.nextDouble() > p ? 1.0 - p : p;
        double y = this.exponential(mean) / (2.0 * d);
        return y;
    }

    public double hypoexponential(double mean, double var) {
        int n = (int)(mean * mean / var + 0.5);
        double res = 0.0;
        double x = mean / (double)n;
        int i = 1;
        while (i < n) {
            res += this.exponential(x);
            ++i;
        }
        return res += this.exponential(mean - (double)(n - 1) * x);
    }

    public double normal(double mean, double stddev) {
        double sum = 0.0;
        int i = 1;
        while (i <= 12) {
            sum += this.m_random.nextDouble();
            ++i;
        }
        double res = stddev * (sum - 6.0) + mean;
        return res;
    }

    public double triangular(double minimum, double maximum, double mode) {
        double res;
        if (maximum < minimum || minimum > mode || maximum < mode) {
            throw new RuntimeException("triangular: parameter error");
        }
        if (maximum == minimum && maximum == mode) {
            res = maximum;
        } else if (maximum < minimum || mode < minimum || mode > maximum) {
            res = 0.0;
        } else {
            double mode01 = (mode - minimum) / (maximum - minimum);
            double unif = this.m_random.nextDouble();
            double x = unif <= mode01 ? Math.sqrt(mode01 * unif) : 1.0 - Math.sqrt((1.0 - mode01) * (1.0 - unif));
            res = minimum + (maximum - minimum) * x;
        }
        return res;
    }

    public double uniform(double min, double max) {
        if (max < min) {
            throw new RuntimeException("uniform: max < min");
        }
        double x = this.m_random.nextDouble();
        return min + x * (max - min);
    }

    public double uniform01() {
        return this.m_random.nextDouble();
    }

    public int uniform_int(int min, int max) {
        if (max < min) {
            throw new RuntimeException("uniform_int: max < min");
        }
        if (max == min) {
            return min;
        }
        double x = this.m_random.nextDouble();
        return min + (int)Math.floor(x * (double)(max - min + 1));
    }
}

