/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.csim;

import com.mesquite.csim.Facility;
import com.mesquite.csim.Process;
import com.mesquite.csim.Server;

public class RNDROBFacility
extends Facility {
    private static int m_current = 0;
    private static double m_timeSlice = 1.0;

    public RNDROBFacility() {
        this(1);
    }

    public RNDROBFacility(int numServers) {
        this("def", numServers);
    }

    public RNDROBFacility(String name) {
        this(name, 1);
    }

    public RNDROBFacility(String name, int numServers) {
        super(name, "rnd_rob", numServers);
    }

    protected void useFunc(double interval) {
        if (this.model().traceEnabled()) {
            this.model().traceEvent("reserve facility " + this.name());
        }
        ++m_current;
        Process p = this.model().getActiveProcess();
        double timeRemaining = interval;
        double thisSlice = m_timeSlice;
        this.reserve();
        while (timeRemaining > 1.0E-6) {
            thisSlice = timeRemaining > m_timeSlice ? m_timeSlice : timeRemaining;
            timeRemaining -= thisSlice;
            p.hold(thisSlice);
            if (this.qlength() <= 0 || !(timeRemaining > 1.0E-6)) continue;
            this.release();
            this.reserve();
        }
        this.release();
        --m_current;
        if (this.model().traceEnabled()) {
            this.model().traceEvent("release facility " + this.name());
        }
    }

    public void set_timeslice(double slice) {
        m_timeSlice = slice;
    }

    public double timeslice() {
        return m_timeSlice;
    }

    private void release() {
        this.model().checkThread();
        this.xrelease();
    }

    private int reserve() {
        this.model().checkThread();
        Process p = this.model().getActiveProcess();
        Server s = this.xreserve(p);
        if (s == null) {
            p.suspendAndFire();
            s = this.findServer(p);
        }
        if (s == null) {
            return -1;
        }
        return s.index();
    }
}

