/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.csim;

import com.mesquite.csim.Facility;
import com.mesquite.csim.Process;
import com.mesquite.csim.Server;

public class RNDPREFacility
extends Facility {
    private static int m_current = 0;
    private static double m_timeSlice = 1.0;

    public RNDPREFacility() {
        this(1);
    }

    public RNDPREFacility(int numServers) {
        this("def", numServers);
    }

    public RNDPREFacility(String name) {
        this(name, 1);
    }

    public RNDPREFacility(String name, int numServers) {
        super(name, "rndPre", numServers);
    }

    protected void useFunc(double interval) {
        boolean result;
        ++m_current;
        Process p = this.model().getActiveProcess();
        if (this.model().traceEnabled()) {
            this.model().traceEvent("reserve facility " + this.name() + " process " + p.name());
        }
        if (!(result = this.preemptResume(p, p.priority(), interval))) {
            p.suspendAndFire();
        }
        double timeRemaining = interval;
        double thisSlice = m_timeSlice;
        while (timeRemaining > 1.0E-6) {
            thisSlice = timeRemaining > m_timeSlice ? m_timeSlice : timeRemaining;
            timeRemaining -= thisSlice;
            p.hold(thisSlice);
            if (this.qlength() <= 0 || this.first_process().priority() < p.priority() || !(timeRemaining > 1.0E-6)) continue;
            this.release();
            this.reserve();
        }
        this.release();
        --m_current;
        if (this.model().traceEnabled()) {
            this.model().traceEvent("release facility " + this.name() + " process " + p.name());
        }
    }

    public void set_timeslice(double slice) {
        m_timeSlice = slice;
    }

    public double timeslice() {
        return m_timeSlice;
    }

    private void release() {
        this.model().checkThread();
        this.xrelease();
    }

    private int reserve() {
        this.model().checkThread();
        Process p = this.model().getActiveProcess();
        Server s = this.xreserve(p);
        if (s == null) {
            p.suspendAndFire();
            s = this.findServer(p);
        }
        if (s == null) {
            return -1;
        }
        return s.index();
    }
}

