/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.csim;

import com.mesquite.csim.Model;
import com.mesquite.csim.Process;
import com.mesquite.queue.HeapPriorityQueue;
import com.mesquite.queue.PriorityQueue;
import java.util.Comparator;
import java.util.Iterator;

public class ProcessQueue {
    private final Model m_model;
    private final PriorityQueue m_queue = new HeapPriorityQueue(s_comparator);
    private double m_waitSum;
    private double m_lastChangeTime;
    private static final Comparator s_comparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            Process p1 = (Process)o1;
            Process p2 = (Process)o2;
            return p1.priority() - p2.priority();
        }
    };

    public ProcessQueue() {
        this(Model.currentModel());
    }

    public ProcessQueue(Model model) {
        this.m_model = model;
        this.m_lastChangeTime = this.m_model.clock();
        this.reset();
    }

    public void add(Process p) {
        this.updateStats();
        this.m_queue.add(p);
        p.onQueueAdd(this);
        p.setRemoved(false);
    }

    public boolean isEmpty() {
        return this.m_queue.isEmpty();
    }

    public Iterator iterator() {
        return this.m_queue.iterator();
    }

    public Process peek() {
        return (Process)this.m_queue.peek();
    }

    public Process lastProcess() {
        return (Process)this.m_queue.lastElement();
    }

    public void reset() {
        this.m_waitSum = 0.0;
    }

    public int size() {
        return this.m_queue.size();
    }

    public Process remove() {
        this.updateStats();
        Process p = (Process)this.m_queue.remove();
        p.onQueueRemove();
        p.setRemoved(true);
        return p;
    }

    public void remove(Process p) {
        this.updateStats();
        this.m_queue.remove(p);
        p.onQueueRemove();
        p.setRemoved(true);
    }

    public double waitTime() {
        return this.m_waitSum;
    }

    private void updateStats() {
        double time = this.m_model.clock();
        this.m_waitSum += (double)this.m_queue.size() * (time - this.m_lastChangeTime);
        this.m_lastChangeTime = time;
    }
}

