/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.csim;

import com.mesquite.csim.AbstractStatKeeper;
import com.mesquite.csim.Model;
import com.mesquite.csim.Process;

public class ProcessClass
extends AbstractStatKeeper {
    private int m_count = 0;
    private int m_current = 0;
    private double m_lifeTimeSum = 0.0;
    private double m_lifeTimeLastChange;
    private int m_holdCount = 0;
    private int m_holdCurrent = 0;
    private double m_holdSum = 0.0;
    private double m_holdLastChange;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.mesquite.csim.ProcessClass");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ProcessClass(String name) {
        this(name, Model.currentModel());
    }

    public ProcessClass(String name, Model model) {
        super("processClass", name, model);
        double time;
        this.m_lifeTimeLastChange = time = model.clock();
        this.m_holdLastChange = time;
    }

    public int count() {
        return this.m_count;
    }

    public int holdCount() {
        return this.m_holdCount;
    }

    public double holdTime() {
        this.updateHoldTime();
        return this.m_holdSum;
    }

    public double lifetime() {
        this.updateLifeTime();
        return this.m_lifeTimeSum;
    }

    public void reset() {
        double time = this.model().clock();
        this.m_lifeTimeSum = 0.0;
        this.m_lifeTimeLastChange = time;
        this.m_holdCount = 0;
        this.m_holdSum = 0.0;
        this.m_holdLastChange = time;
    }

    void startHold(Process p) {
        this.updateHoldTime();
        ++this.m_holdCurrent;
    }

    void endHold(Process p) {
        if (!$assertionsDisabled && this.m_holdCurrent <= 0) {
            throw new AssertionError();
        }
        this.updateHoldTime();
        --this.m_holdCurrent;
        ++this.m_holdCount;
    }

    void add(Process p) {
        this.updateLifeTime();
        ++this.m_count;
        ++this.m_current;
    }

    void remove(Process p) {
        if (!$assertionsDisabled && this.m_current <= 0) {
            throw new AssertionError();
        }
        this.updateLifeTime();
        --this.m_current;
    }

    private void updateLifeTime() {
        double time = this.model().clock();
        this.m_lifeTimeSum += (double)this.m_current * (time - this.m_lifeTimeLastChange);
        this.m_lifeTimeLastChange = time;
    }

    private void updateHoldTime() {
        double time = this.model().clock();
        this.m_holdSum += (double)this.m_holdCurrent * (time - this.m_holdLastChange);
        this.m_holdLastChange = time;
    }
}

