/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.csim;

import com.mesquite.csim.Model;
import com.mesquite.csim.ProcessClass;
import com.mesquite.csim.ProcessQueue;
import com.mesquite.csim.Random;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class Process {
    protected Random rand = null;
    protected Model model = null;
    int eventIndex = 0;
    double rtime = -1.0;
    int storageRequest = -1;
    Object processStructure = null;
    private boolean m_canWake = false;
    private int m_id = 0;
    private String m_name;
    private int m_priority = 1;
    private int m_savedPriority = 0;
    private Thread m_thread = null;
    private ProcessClass m_class = null;
    private ProcessQueue m_queue = null;
    private boolean m_scheduled = false;
    private boolean m_removed = false;
    private boolean m_done = false;
    private final Object m_joinSync = new Object();
    private Object m_queueToken = null;
    private static final Map s_class2name;
    private static final boolean s_debugTrace = false;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.mesquite.csim.Process");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        s_class2name = Collections.synchronizedMap(new HashMap());
    }

    public Process() {
        this.m_name = Process.getClassName(this.getClass());
    }

    public Process(String name) {
        this.m_name = name;
    }

    public final int priority() {
        return this.m_priority;
    }

    public final void setPriority(int n) {
        this.m_priority = n;
        if (this.model.traceEnabled()) {
            this.model.traceEvent("set priority " + String.valueOf(this.m_priority));
        }
    }

    public final int identity() {
        return this.m_id;
    }

    public final String name() {
        return this.m_name;
    }

    public final void setName(String name) {
        this.m_name = name;
    }

    public void setProcessStructure(Object ps) {
        this.processStructure = ps;
    }

    public Object getProcessStructure() {
        return this.processStructure;
    }

    public final Model model() {
        return this.model;
    }

    public final ProcessClass getProcessClass() {
        return this.m_class;
    }

    public final void setProcessClass(ProcessClass c) {
        this.checkThread();
        if (this.m_class != null) {
            this.m_class.remove(this);
        }
        this.m_class = c;
        if (this.m_class != null) {
            this.m_class.add(this);
            if (this.model.traceEnabled()) {
                this.model.traceEvent("join class " + c.name());
            }
        }
    }

    public void savePriority() {
        this.m_savedPriority = this.m_priority;
    }

    public void restorePriority() {
        this.m_priority = this.m_savedPriority;
    }

    public void restart() {
        this.model.schedule(0.0, this);
    }

    public abstract void run();

    public void hold(double interval) {
        this.debugTrace("Begin hold");
        this.checkThread();
        if (this.m_class != null) {
            this.m_class.startHold(this);
        }
        if (this.model.traceEnabled()) {
            this.model.traceEvent("hold for " + Model.s_timeFormat.format(interval));
        }
        this.model.schedule(interval, this);
        this.suspendAndFire();
        if (this.m_class != null) {
            this.m_class.endHold(this);
        }
        this.debugTrace("End hold");
    }

    public void terminate() {
        this.debugTrace("Terminate");
        this.checkThread();
        if (this.model.traceEnabled()) {
            this.model.traceEvent(this, "terminate process");
        }
        if (this.m_class != null) {
            this.m_class.remove(this);
            this.m_class = null;
        }
        if (this.m_id == 1) {
            this.model.halt();
        } else {
            this.model.nextEvent();
        }
        this.kill();
    }

    final void addToModel(Model m, int id) {
        if (!$assertionsDisabled && this.model != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.m_id != 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.m_thread != null) {
            throw new AssertionError();
        }
        this.model = m;
        this.m_id = id;
        if (this.m_id != 1) {
            this.m_priority = this.model.getActiveProcess().priority();
        }
        this.m_thread = this.model.getThread(new ProcessRunner());
        this.m_thread.setName(this.name());
        if (this.rand == null) {
            this.rand = this.model.random();
        }
        this.m_canWake = false;
        this.model.schedule(0.0, this);
        if (this.model.traceEnabled()) {
            Process p = this.model.getActiveProcess();
            if (p == null) {
                p = this;
            }
            String str = "create " + this.name() + " " + this.identity();
            this.model.traceEvent(p, str);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void join() {
        Object object = this.m_joinSync;
        synchronized (object) {
            while (true) {
                if (this.m_done) {
                    return;
                }
                try {
                    this.m_joinSync.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void kill() {
        this.checkThread();
        this.m_thread.setName("(unused)");
        if (this.m_class != null) {
            this.m_class.remove(this);
        }
        this.model.remove(this);
        Object object = this.m_joinSync;
        synchronized (object) {
            this.m_done = true;
            this.m_joinSync.notifyAll();
        }
        throw new ThreadDeath();
    }

    final void onQueueAdd(ProcessQueue queue) {
        if (!$assertionsDisabled && this.m_queue != null) {
            throw new AssertionError();
        }
        this.m_queue = queue;
    }

    final void onQueueRemove() {
        if (!$assertionsDisabled && this.m_queue == null) {
            throw new AssertionError();
        }
        this.m_queue = null;
    }

    final ProcessQueue queue() {
        return this.m_queue;
    }

    final boolean getRemoved() {
        return this.m_removed;
    }

    void setRemoved(boolean v) {
        this.m_removed = v;
    }

    final synchronized void resume() {
        this.debugTrace("Notify for resume");
        this.m_canWake = true;
        this.notifyAll();
    }

    private synchronized void suspend() {
        this.debugTrace("Preparing to suspend");
        while (!this.m_canWake) {
            this.debugTrace("Suspend");
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                this.kill();
            }
            this.debugTrace("Resume");
        }
        this.m_canWake = false;
    }

    final void suspendAndFire() {
        this.checkThread();
        this.model.nextEvent();
        this.suspend();
    }

    final Thread thread() {
        return this.m_thread;
    }

    private void checkThread() {
        if (Thread.currentThread() != this.m_thread) {
            throw new RuntimeException("checkThread: thread error");
        }
    }

    private void debugTrace(String message) {
    }

    private static String getClassName(Class c) {
        String name = (String)s_class2name.get(c);
        if (name == null) {
            name = c.getName();
            int index = name.lastIndexOf(36);
            if (index == -1) {
                index = name.lastIndexOf(46);
            }
            if (index != -1) {
                name = name.substring(++index);
            }
            s_class2name.put(c, name);
        }
        return name;
    }

    private final class ProcessRunner
    implements Runnable {
        ProcessRunner() {
        }

        public void run() {
            Process.this.suspend();
            Process.this.run();
            Process.this.terminate();
        }
    }
}

