/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.csim;

import com.mesquite.csim.Event;
import com.mesquite.csim.Process;
import com.mesquite.csim.ProcessClass;
import com.mesquite.csim.Random;
import com.mesquite.csim.registry.BoxGroup;
import com.mesquite.csim.registry.BufferGroup;
import com.mesquite.csim.registry.Counter;
import com.mesquite.csim.registry.EventGroup;
import com.mesquite.csim.registry.FacilityGroup;
import com.mesquite.csim.registry.MailboxGroup;
import com.mesquite.csim.registry.MeterGroup;
import com.mesquite.csim.registry.ProcessClassGroup;
import com.mesquite.csim.registry.QTableGroup;
import com.mesquite.csim.registry.Registry;
import com.mesquite.csim.registry.StorageGroup;
import com.mesquite.csim.registry.TableGroup;
import com.mesquite.queue.HeapPriorityQueue;
import com.mesquite.queue.PriorityQueue;
import com.mesquite.text.Align;
import com.mesquite.util.ThreadPool;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class Model {
    private String m_name;
    private Process m_activeProcess = null;
    private Thread m_activeThread = null;
    private double m_clock;
    private double m_beginClock;
    private PriorityQueue m_eventQ;
    private final Counter m_processCounter = new Counter(1);
    private final Map m_proc2event = new HashMap();
    private Throwable m_exception;
    private final ThreadGroup m_threadGroup;
    private final ThreadPool m_threadPool;
    private ProcessClass m_defaultClass = null;
    private Event m_eventListEmpty = null;
    private Event m_converged = null;
    private final Registry m_registry = new Registry();
    private final Counter m_resourceCounter = new Counter(1);
    private Random m_random = new Random(1L);
    private long m_firstStartSystemTime;
    private long m_startSystemTime;
    private long m_endSystemTime;
    private PrintStream m_output = System.out;
    private PrintStream m_trace = System.out;
    private boolean m_doTrace = false;
    private int m_traceLine = 0;
    private int m_state = 0;
    private static final int STATE_NEW = 0;
    private static final int STATE_INITIALIZED = 1;
    private static final int STATE_RUNNING = 2;
    private static final int STATE_TERMINATED = 3;
    private static final int s_traceHeaderInterval = 54;
    static final DecimalFormat s_timeFormat;
    static final DecimalFormat s_timeFormat6;
    private static final Map s_threadGroup2model;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.mesquite.csim.Model");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        s_timeFormat = new DecimalFormat("0.000");
        s_timeFormat6 = new DecimalFormat("0.000000");
        s_threadGroup2model = Collections.synchronizedMap(new HashMap());
    }

    public Model() {
        this("def");
    }

    public Model(String name) {
        this.m_name = name;
        this.m_state = 1;
        this.m_threadGroup = new ThreadGroup(name);
        this.m_threadPool = new ThreadPool(this.m_threadGroup);
        this.m_registry.addGroup("facility", new FacilityGroup(this.m_resourceCounter));
        this.m_registry.addGroup("storage", new StorageGroup(this.m_resourceCounter));
        this.m_registry.addGroup("buffer", new BufferGroup(this.m_resourceCounter));
        this.m_registry.addGroup("processClass", new ProcessClassGroup());
        this.m_registry.addGroup("event", new EventGroup(this.m_resourceCounter));
        this.m_registry.addGroup("mailbox", new MailboxGroup(this.m_resourceCounter));
        this.m_registry.addGroup("table", new TableGroup());
        this.m_registry.addGroup("qtable", new QTableGroup());
        this.m_registry.addGroup("meter", new MeterGroup());
        this.m_registry.addGroup("box", new BoxGroup());
    }

    public void add(Process p) {
        if (this.m_state != 2) {
            throw new IllegalStateException("add: model not running");
        }
        p.addToModel(this, this.m_processCounter.next());
    }

    public final double clock() {
        return this.m_clock;
    }

    public final double beginTime() {
        return this.m_beginClock;
    }

    public final double elapsedTime() {
        return this.m_clock - this.m_beginClock;
    }

    public final double executionTime() {
        this.m_endSystemTime = System.currentTimeMillis();
        return (double)(this.m_endSystemTime - this.m_startSystemTime) / 1000.0;
    }

    public static Model currentModel() {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        Model model = (Model)s_threadGroup2model.get(group);
        if (model == null) {
            throw new RuntimeException("currentModel: Not inside any model");
        }
        return model;
    }

    public ProcessClass defaultProcessClass() {
        return this.m_defaultClass;
    }

    public void enableTrace(boolean doTrace) {
        this.m_doTrace = doTrace;
    }

    public Event eventListEmpty() {
        return this.m_eventListEmpty;
    }

    public Event converged() {
        return this.m_converged;
    }

    public Process getActiveProcess() {
        return this.m_activeProcess;
    }

    public PrintStream getOutputStream() {
        return this.m_output;
    }

    public String name() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public Registry registry() {
        return this.m_registry;
    }

    public void report() {
        if (this.m_output == null) {
            return;
        }
        this.reportHeader();
        this.m_registry.report(this.m_output);
    }

    private void reportGroup(String group) {
        this.m_registry.reportGroup(group, this.m_output);
    }

    public void report_facilities() {
        this.m_registry.reportGroup("facility", this.m_output);
    }

    public void report_storages() {
        this.m_registry.reportGroup("storage", this.m_output);
    }

    public void report_buffers() {
        this.m_registry.reportGroup("buffer", this.m_output);
    }

    public void report_events() {
        this.m_registry.reportGroup("event", this.m_output);
    }

    public void report_mailboxes() {
        this.m_registry.reportGroup("mailbox", this.m_output);
    }

    public void report_tables() {
        this.m_registry.reportGroup("table", this.m_output);
    }

    public void report_qtables() {
        this.m_registry.reportGroup("qtable", this.m_output);
    }

    public void report_boxes() {
        this.m_registry.reportGroup("box", this.m_output);
    }

    public void report_meters() {
        this.m_registry.reportGroup("meter", this.m_output);
    }

    private void Center(String s) {
        int leadingBlanks = (80 - s.length()) / 2;
        int i = 0;
        while (i < leadingBlanks) {
            this.m_output.print(" ");
            ++i;
        }
    }

    public String timeOfDay() {
        Date currentDateTime = new Date();
        DateFormat fullDate = DateFormat.getDateTimeInstance(1, 1);
        String str = fullDate.format(currentDateTime);
        return str;
    }

    public void report_hdr() {
        this.reportHeader();
    }

    public void reportHeader() {
        this.m_output.println("");
        String str = "CSIM/Java Simulation Report";
        this.Center(str);
        this.m_output.println(str);
        this.m_output.println("");
        if (this.m_name != "") {
            str = this.m_name;
            this.Center(str);
            this.m_output.println(str);
            this.m_output.println("");
        }
        str = this.timeOfDay();
        this.Center(str);
        this.m_output.println(str);
        this.m_output.println("");
        String str1 = s_timeFormat.format(this.clock());
        str = "Ending Simulation time:    " + Align.right(str1, 15);
        this.Center(str);
        this.m_output.println(str);
        str1 = s_timeFormat.format(this.elapsedTime());
        str = "Elapsed Simulation time:   " + Align.right(str1, 15);
        this.Center(str);
        this.m_output.println(str);
        str1 = s_timeFormat.format(this.executionTime());
        str = "Execution (CPU) time:      " + Align.right(str1, 15);
        this.Center(str);
        this.m_output.println(str);
        this.m_output.println();
    }

    public void start(Process p) {
        if (this.m_state != 1 && this.m_state != 3) {
            throw new IllegalStateException("start: model already running");
        }
        this.m_processCounter.reset();
        this.m_resourceCounter.reset();
        this.m_registry.start();
        this.m_exception = null;
        this.m_beginClock = 0.0;
        this.m_clock = 0.0;
        this.m_firstStartSystemTime = this.m_startSystemTime = System.currentTimeMillis();
        this.m_state = 2;
        s_threadGroup2model.put(this.m_threadGroup, this);
        this.m_threadPool.enable();
        this.init();
        this.add(p);
        this.nextEvent();
        p.join();
        this.m_registry.stop();
        this.m_threadPool.disable();
        s_threadGroup2model.remove(this.m_threadGroup);
        this.m_state = 3;
        this.m_endSystemTime = System.currentTimeMillis();
        double time = (double)(this.m_endSystemTime - this.m_firstStartSystemTime) / 1000.0;
        System.out.println("Execution time: " + time);
        if (this.m_exception != null) {
            String msg = this.m_exception.getMessage();
            this.m_exception = null;
            throw new RuntimeException(msg);
        }
    }

    public void setOutputFile(String filename) {
        FileOutputStream s = null;
        try {
            s = new FileOutputStream(filename);
        }
        catch (FileNotFoundException e) {
            System.err.print("setOutputFile: Could not open output file ");
            System.err.println(filename);
            System.exit(0);
        }
        this.m_output = new PrintStream(s);
    }

    public void setOutputStream(PrintStream s) {
        if (this.m_state != 1) {
            throw new IllegalStateException("setOutputStream: not initialize");
        }
        this.m_output = s;
    }

    public void setRandom(Random r) {
        this.m_random = r;
    }

    public void setTraceFile(String filename) {
        FileOutputStream s = null;
        try {
            s = new FileOutputStream(filename);
        }
        catch (FileNotFoundException e) {
            System.err.print("setTraceFile: Could not open trace file ");
            System.err.println(filename);
            System.exit(0);
        }
        this.m_trace = new PrintStream(s);
    }

    public void setTraceStream(PrintStream s) {
        if (this.m_state != 1) {
            throw new IllegalStateException("setTraceStream: Simulation has already started");
        }
        this.m_trace = s;
    }

    public void halt() {
        this.checkThread();
        if (this.traceEnabled()) {
            this.traceEvent("halt simulation");
        }
        this.m_threadGroup.interrupt();
        this.m_activeProcess.kill();
    }

    public Random random() {
        return this.m_random;
    }

    public boolean traceEnabled() {
        return this.m_trace != null && this.m_doTrace;
    }

    public void reset() {
        this.m_registry.reset();
        this.m_beginClock = this.m_clock;
        this.m_startSystemTime = this.m_endSystemTime;
    }

    public void dump_status() {
        this.m_output.println("Model Status: csim_clock = " + String.valueOf(this.m_clock));
        this.m_output.println();
        this.registry().status(this.m_output);
        this.status_next_event_list();
    }

    public void status_facilities() {
        this.m_registry.statusGroup("facility", this.m_output);
    }

    public void status_storages() {
        this.m_registry.statusGroup("storage", this.m_output);
    }

    public void status_buffers() {
        this.m_registry.statusGroup("buffer", this.m_output);
    }

    public void status_events() {
        this.m_registry.statusGroup("event", this.m_output);
    }

    public void status_mailboxes() {
        this.m_registry.statusGroup("mailbox", this.m_output);
    }

    public void status_next_event_list() {
        this.m_output.println("STATUS OF EVENT LIST");
        this.m_output.println("position       time         process              event type");
        this.m_output.println("-----------------------------------------------------------");
        LinkedList<Object> look = new LinkedList<Object>();
        while (!this.m_eventQ.isEmpty()) {
            look.add(this.m_eventQ.remove());
        }
        Iterator it = look.iterator();
        int n = 0;
        while (it.hasNext()) {
            this.m_output.print(String.valueOf(Align.right(String.valueOf(n++), 5)) + "    ");
            EventItem e = (EventItem)it.next();
            double etime = e.time;
            this.m_output.print(Align.right(s_timeFormat6.format(etime), 10));
            this.m_output.print("         ");
            Process p = e.process;
            this.m_output.print(String.valueOf(p.name()) + "." + p.identity());
            this.m_output.println();
            this.m_eventQ.add(e);
        }
        this.m_output.println();
    }

    public void collect_class_facility_all() {
        this.m_registry.collectClassStats(this.m_output);
    }

    EventItem cancel(Process p) {
        EventItem result = (EventItem)this.m_proc2event.remove(p);
        if (!$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        LinkedList<Object> look = new LinkedList<Object>();
        while (!this.m_eventQ.isEmpty()) {
            look.add(this.m_eventQ.remove());
        }
        Iterator it = look.iterator();
        while (it.hasNext()) {
            EventItem e = (EventItem)it.next();
            Process pp = e.process;
            if (pp != p) {
                this.m_eventQ.add(e);
                continue;
            }
            result = e;
        }
        return result;
    }

    void checkThread() {
        if (Thread.currentThread() != this.m_activeThread) {
            throw new RuntimeException("checkThread: current thread not active thread");
        }
    }

    Thread getActiveThread() {
        return this.m_activeThread;
    }

    Thread getThread(Runnable target) {
        return this.m_threadPool.get(target);
    }

    boolean hasEvent(Process p) {
        return this.m_proc2event.containsKey(p);
    }

    void init() {
        this.m_defaultClass = new ProcessClass("default", this);
        this.m_eventListEmpty = new Event("evnt_list_empty", this);
        this.m_converged = new Event("converged", this);
        this.m_eventQ = new HeapPriorityQueue();
    }

    void nextEvent() {
        if (this.m_eventQ.isEmpty()) {
            if (this.m_eventListEmpty.wait_cnt() > 0) {
                this.m_eventListEmpty.set();
            } else {
                throw new IllegalStateException("nextEvent: No more events");
            }
        }
        EventItem event = (EventItem)this.m_eventQ.remove();
        Process p = event.process;
        this.m_proc2event.remove(p);
        if (event.time < this.m_clock) {
            throw new AssertionError((Object)"Time going backwards");
        }
        this.m_clock = event.time;
        this.setActiveProcess(p);
        p.resume();
    }

    void remove(Process p) {
    }

    void reschedule(double interval, Process p) {
        double time = this.m_clock + interval;
        if (!$assertionsDisabled && interval != 0.0) {
            throw new AssertionError();
        }
        EventItem e = (EventItem)this.m_proc2event.get(p);
        if (e != null) {
            if (e.time == time) {
                EventItem item = new EventItem(time, p, this.m_activeThread);
                this.m_eventQ.replace(e, item);
                if (this.traceEnabled()) {
                    String str = s_timeFormat.format(interval);
                    str = "sched proc: t = " + str + ", id = " + p.identity();
                    this.traceEvent(str);
                }
            } else {
                this.cancel(p);
                this.schedule(interval, p);
            }
        } else {
            this.schedule(interval, p);
        }
    }

    void schedule(double interval) {
        this.schedule(interval, this.m_activeProcess);
    }

    void schedule(double interval, Process p) {
        if (interval < 0.0) {
            throw new RuntimeException("schedule: interval cannot be negative");
        }
        double time = this.m_clock + interval;
        if (!$assertionsDisabled && this.m_proc2event.containsKey(p)) {
            throw new AssertionError();
        }
        if (this.m_activeProcess != null && this.traceEnabled()) {
            String str = s_timeFormat.format(interval);
            this.traceEvent("sched proc: t = " + str + ", id = " + p.identity());
        }
        EventItem event = new EventItem(time, p, Thread.currentThread());
        this.m_eventQ.add(event);
        this.m_proc2event.put(p, event);
    }

    void setActiveProcess(Process p) {
        this.m_activeProcess = p;
        this.m_activeThread = p.thread();
    }

    ThreadGroup threadGroup() {
        return this.m_threadGroup;
    }

    void haltOnException(Throwable e) {
        if (this.m_exception == null) {
            this.m_exception = e;
        }
        this.halt();
    }

    void traceEvent(String status) {
        this.traceEvent(this.m_activeProcess, status);
    }

    void traceEvent(Process p, String status) {
        if (this.traceEnabled() && p != null) {
            if (this.m_traceLine % 54 == 0) {
                this.m_trace.println("      time      process  id   pri    status");
            }
            ++this.m_traceLine;
            this.m_trace.print(Align.right(s_timeFormat.format(this.clock()), 10));
            this.m_trace.print(" ");
            this.m_trace.print(Align.right(p.name(), 12));
            this.m_trace.print(" ");
            this.m_trace.print(Align.right(String.valueOf(p.identity()), 3));
            this.m_trace.print(" ");
            this.m_trace.print(Align.right(String.valueOf(p.priority()), 5));
            this.m_trace.print("    ");
            this.m_trace.println(status);
        }
    }

    static final class EventItem
    implements Comparable {
        public final double time;
        public final Process process;

        EventItem(double time, Process p, Thread cause) {
            this.time = time;
            this.process = p;
        }

        public int compareTo(Object o) {
            EventItem other = (EventItem)o;
            return Double.compare(other.time, this.time);
        }
    }
}

