/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.csim;

import com.mesquite.csim.AbstractStatKeeper;
import com.mesquite.csim.BasicTable;
import com.mesquite.csim.Model;

public class Meter
extends AbstractStatKeeper {
    private double m_last_passage;
    private double m_count;
    private double m_startTime;
    private double m_resetTime;
    private BasicTable m_inter_pass_time = new BasicTable();

    public Meter(String name) {
        this(name, Model.currentModel());
    }

    public Meter(String name, Model model) {
        super("meter", name, Model.currentModel());
        this.m_startTime = model.clock();
        this.reset();
    }

    public void reset() {
        this.m_count = 0.0;
        this.m_resetTime = this.model().clock();
        this.m_inter_pass_time.reset();
    }

    public void note_passage() {
        this.m_count += 1.0;
        this.m_inter_pass_time.record(this.model().clock() - this.m_last_passage);
        this.m_last_passage = this.model().clock();
    }

    public int count() {
        return (int)this.m_count;
    }

    public double rate() {
        double elapsedTime = this.model().clock() - this.m_resetTime;
        double rate = elapsedTime > 0.0 ? (double)this.count() / elapsedTime : 0.0;
        return rate;
    }

    public BasicTable ip_table() {
        return this.m_inter_pass_time;
    }

    public void add_histogram(int n, double lo, double hi) {
        this.m_inter_pass_time.add_histogram(n, lo, hi);
    }

    public void confidence() {
        this.m_inter_pass_time.confidence();
    }
}

