/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.csim;

import com.mesquite.csim.AbstractResource;
import com.mesquite.csim.Event;
import com.mesquite.csim.Model;
import com.mesquite.csim.Process;
import com.mesquite.csim.ProcessQueue;
import java.util.LinkedList;
import java.util.List;

public class Mailbox
extends AbstractResource {
    private Event m_event;
    private final LinkedList m_msgQueue = new LinkedList();
    private boolean m_reportEnabled = false;
    private int m_mbCnt;
    private int m_procCount;
    private int m_procVisits;
    private double m_procSum;
    private double m_procLast;
    private int m_msgCount;
    private int m_msgVisits;
    private double m_msgSum;
    private double m_msgLast;
    private double m_startTime;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.mesquite.csim.Mailbox");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public Mailbox(String name) {
        this(name, Model.currentModel());
    }

    public Mailbox(String name, Model model) {
        super("mailbox", name, model);
        String str = String.valueOf(name) + ".mb";
        this.m_event = new Event(str, model);
        this.m_procLast = this.model().clock();
        this.m_msgLast = this.model().clock();
        this.m_mbCnt = 0;
        this.reset();
        if (this.model().traceEnabled()) {
            Process p = this.model().getActiveProcess();
            String s = "init mailbox " + this.name();
            this.model().traceEvent(p, s);
        }
    }

    public boolean reportEnabled() {
        return this.m_reportEnabled;
    }

    public void collect() {
    }

    public void reset() {
        this.m_procVisits = 0;
        this.m_procCount = 0;
        this.m_procSum = 0.0;
        this.m_msgVisits = 0;
        this.m_msgCount = 0;
        this.m_msgSum = 0.0;
        this.m_event.reset();
        this.m_startTime = this.model().clock();
    }

    public ProcessQueue getQueue() {
        return this.m_event.getQueueQueue();
    }

    public void monitor() {
        this.m_reportEnabled = true;
    }

    public double proc_sum() {
        return this.m_procSum;
    }

    public int proc_delay_count() {
        return this.m_procCount;
    }

    public int proc_queue_count() {
        return this.m_event.queue_cnt();
    }

    public int proc_count() {
        return this.m_procVisits;
    }

    public double proc_time() {
        return this.proc_count() > 0 ? this.proc_sum() / (double)this.proc_count() : 0.0;
    }

    public double proc_length() {
        double etime = this.model().clock() - this.m_startTime;
        return etime > 0.0 ? this.proc_sum() / etime : 0.0;
    }

    public double msg_sum() {
        return this.m_msgSum;
    }

    public int msg_delay_count() {
        return this.m_msgCount;
    }

    public int msg_count() {
        return this.m_msgVisits;
    }

    public double msg_time() {
        return this.msg_delay_count() > 0 ? this.msg_sum() / (double)this.msg_delay_count() : 0.0;
    }

    public double msg_length() {
        double etime = this.model().clock() - this.m_startTime;
        return etime > 0.0 ? this.msg_sum() / etime : 0.0;
    }

    public int num_messages() {
        return this.m_msgQueue.size();
    }

    public Process first_process() {
        return this.m_event.first_queue_process();
    }

    public Process last_process() {
        return this.m_event.last_queue_process();
    }

    public Process remove_process(Process pr) {
        Process res = this.m_event.remove_queue_process(pr);
        return res;
    }

    public void insert_process(Process pr) {
        this.m_event.insert_queue_process(pr);
    }

    public List process_list() {
        List pList = new LinkedList();
        pList = this.m_event.queue_process_list();
        return pList;
    }

    public Object first_message() {
        if (this.num_messages() > 0) {
            return this.m_msgQueue.getFirst();
        }
        return null;
    }

    public Object last_message() {
        if (this.num_messages() > 0) {
            return this.m_msgQueue.getLast();
        }
        return null;
    }

    public Object remove_message(Object obj) {
        if (this.m_msgQueue.remove(obj)) {
            this.m_msgSum += (this.model().clock() - this.m_msgLast) * (double)(this.m_msgQueue.size() + 1);
            this.m_msgLast = this.model().clock();
            --this.m_msgVisits;
            --this.m_mbCnt;
            if (this.m_mbCnt == 0) {
                this.m_event.clear();
            }
            return obj;
        }
        return null;
    }

    public void insert_message(Object obj) {
        this.xsend(obj);
    }

    public Object get_next(Object obj) {
        int index = this.m_msgQueue.indexOf(obj);
        if (index < this.m_msgQueue.size() - 1) {
            return this.m_msgQueue.get(index + 1);
        }
        return null;
    }

    public void send(Object o) {
        Object obj = this.xsend(o);
    }

    protected Object xsend(Object o) {
        ++this.m_msgVisits;
        if (this.model().traceEnabled()) {
            Process p = this.model().getActiveProcess();
            String s = new String("mbox " + this.name() + " send ");
            this.model().traceEvent(p, s);
        }
        this.m_msgQueue.add(o);
        ++this.m_mbCnt;
        this.m_msgSum += (this.model().clock() - this.m_msgLast) * (double)(this.m_msgQueue.size() - 1);
        this.m_msgLast = this.model().clock();
        this.m_event.set();
        return o;
    }

    public Object receive() {
        return this.xreceive();
    }

    public Object timed_receive(double timeOut) {
        Process p = this.model().getActiveProcess();
        this.model().checkThread();
        if (this.model().traceEnabled()) {
            String str = Model.s_timeFormat.format(timeOut);
            this.model().traceEvent("timed recv: " + this.name() + " " + str);
        }
        this.model().schedule(timeOut);
        Object obj = this.xreceive();
        if (p.queue() != null && !p.getRemoved()) {
            if (!$assertionsDisabled && this.model().hasEvent(p)) {
                throw new AssertionError();
            }
            if (this.model().traceEnabled()) {
                this.model().traceEvent("timed out at " + this.name());
            }
            this.m_event.removeQueue(p);
            obj = null;
        } else {
            if (this.model().traceEnabled()) {
                this.model().traceEvent("timed recv " + this.name());
            }
            if (this.model().hasEvent(p)) {
                this.model().cancel(p);
            }
        }
        return obj;
    }

    protected Object xreceive() {
        Object obj;
        Process p;
        ++this.m_procVisits;
        this.m_procSum += (this.model().clock() - this.m_procLast) * (double)this.m_event.queue_cnt();
        this.m_procLast = this.model().clock();
        --this.m_mbCnt;
        if (this.m_mbCnt < 0) {
            this.m_event.queue();
        }
        if ((p = this.model().getActiveProcess()).queue() == null) {
            obj = this.m_msgQueue.removeFirst();
            this.m_msgSum += (this.model().clock() - this.m_msgLast) * (double)(this.m_msgQueue.size() + 1);
            ++this.m_msgCount;
            this.m_msgLast = this.model().clock();
            this.m_procSum += (this.model().clock() - this.m_procLast) * (double)(this.m_event.queue_cnt() + 1);
            this.m_procLast = this.model().clock();
            ++this.m_procCount;
            if (this.m_mbCnt == 0) {
                this.m_event.clear();
            }
            if (this.model().traceEnabled()) {
                String s = "mbox " + this.name() + " recv ";
                this.model().traceEvent(p, s);
            }
        } else {
            obj = null;
        }
        return obj;
    }

    protected class msg_c {
        public int message;

        public msg_c(int mess) {
            this.message = mess;
        }
    }
}

