/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.csim;

import com.mesquite.csim.Facility;
import com.mesquite.csim.Process;
import com.mesquite.csim.ProcessClass;

public class INFFacility
extends Facility {
    private double m_busyTotal;
    private int m_releaseCount;
    private int m_current;
    private double m_queueTime = 0.0;
    private double m_timeLastChange;
    private double m_startTime;

    public INFFacility() {
        this("def");
        this.reset();
    }

    public INFFacility(String name) {
        super(name, "inf_srv", 0);
        this.reset();
    }

    public double busyTotal() {
        return this.m_busyTotal;
    }

    public int releaseCount() {
        return this.m_releaseCount;
    }

    public int num_busy() {
        return this.m_current;
    }

    public int qlength() {
        return this.m_current;
    }

    public int completions() {
        return this.m_releaseCount;
    }

    public double qlen() {
        double etime = this.model().clock() - this.m_startTime;
        return etime > 0.0 ? this.busyTotal() / etime : 0.0;
    }

    public double resp() {
        return this.completions() > 0 ? this.busyTotal() / (double)this.completions() : 0.0;
    }

    public double serv() {
        return this.completions() > 0 ? this.busyTotal() / (double)this.completions() : 0.0;
    }

    public double tput() {
        double etime = this.model().clock();
        return etime > 0.0 ? (double)this.completions() / etime : 0.0;
    }

    public double util() {
        double etime = this.model().clock();
        return etime > 0.0 ? this.busyTotal() / etime : 0.0;
    }

    public void useFunc(double interval) {
        Process p = this.model().getActiveProcess();
        ++this.m_current;
        p.hold(interval);
        this.m_stats.removeInfBusy(interval);
        --this.m_current;
        this.m_busyTotal += interval;
        ++this.m_releaseCount;
        Facility.Stats classStats = null;
        if (this.m_classStats != null) {
            ProcessClass cl = p.getProcessClass();
            classStats = (Facility.Stats)this.m_classStats.get(cl);
            if (classStats == null) {
                classStats = new Facility.Stats(cl);
                this.m_classStats.put(cl, classStats);
            }
            classStats.removeInfBusy(interval);
        }
    }
}

