/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.csim;

import com.mesquite.text.Align;
import java.io.PrintStream;
import java.text.DecimalFormat;

public class Histogram {
    private double h_minimum;
    private double h_increment;
    private int h_numBuckets;
    private double h_total;
    private double[] h_frequency;
    private DecimalFormat s_decimalFormat11;
    private DecimalFormat s_decimalFormat8;
    private DecimalFormat s_intFormat;
    private final int s_maxBar = 20;

    public Histogram(double min, double max, double incr) {
        this.initialize(min, max, incr);
    }

    public Histogram(int lo, int hi, double incr) {
        this.initialize(lo, hi, incr);
    }

    private void initialize(double min, double max, double incr) {
        this.h_minimum = min;
        this.h_increment = incr;
        this.h_numBuckets = this.h_increment > 0.0 ? (int)Math.floor((max - this.h_minimum) / incr) : 0;
        this.h_frequency = new double[this.h_numBuckets + 2];
        this.reset();
    }

    public void reset() {
        int i = 0;
        while (i <= this.h_numBuckets + 1) {
            this.h_frequency[i] = 0.0;
            ++i;
        }
        this.h_total = 0.0;
    }

    public double low() {
        return this.h_minimum;
    }

    public double high() {
        return this.h_minimum + (double)this.h_numBuckets * this.h_increment;
    }

    public int num() {
        return this.h_numBuckets;
    }

    public double total() {
        return this.h_total;
    }

    public double width() {
        return this.h_increment;
    }

    public int bucket(int i) {
        return (int)this.h_frequency[i];
    }

    public double xbucket(int i) {
        return this.h_frequency[i];
    }

    public void update(double value, double weight) {
        int i = value < this.h_minimum ? 0 : (value >= this.h_minimum + (double)this.h_numBuckets * this.h_increment ? this.h_numBuckets + 1 : (int)Math.floor((value - this.h_minimum) / this.h_increment + 1.0));
        int n = i;
        this.h_frequency[n] = this.h_frequency[n] + weight;
        this.h_total += weight;
    }

    public int fullest() {
        if (this.h_total == 0.0) {
            return 0;
        }
        int maxIndex = 0;
        double maxValue = 0.0;
        int i = 0;
        while (i <= this.h_numBuckets + 1) {
            if (this.h_frequency[i] > maxValue) {
                maxIndex = i;
                maxValue = this.h_frequency[i];
            }
            ++i;
        }
        return maxIndex;
    }

    public void report(PrintStream s) {
        double proportion;
        double maxProportion = 0.0;
        double cumulative = 0.0;
        int i = 0;
        while (i <= this.h_numBuckets + 1) {
            proportion = this.h_total > 0.0 ? this.h_frequency[i] / this.h_total : 0.0;
            if (proportion > maxProportion) {
                maxProportion = proportion;
            }
            ++i;
        }
        int startBucket = 0;
        int stopBucket = this.h_numBuckets + 1;
        while (startBucket <= stopBucket && this.h_frequency[startBucket] == 0.0) {
            ++startBucket;
        }
        while (stopBucket >= startBucket && this.h_frequency[stopBucket] == 0.0) {
            --stopBucket;
        }
        if (startBucket == stopBucket && stopBucket <= this.h_numBuckets) {
            ++stopBucket;
        }
        s.println("                                                 cumulative");
        s.println("     lower limit       frequency    proportion   proportion");
        this.s_decimalFormat11 = new DecimalFormat("####0.00000");
        this.s_decimalFormat8 = new DecimalFormat("0.000000");
        cumulative = 0.0;
        i = startBucket;
        while (i <= stopBucket) {
            String str;
            proportion = this.h_total > 0.0 ? this.h_frequency[i] / this.h_total : 0.0;
            cumulative += proportion;
            if (i == 0) {
                s.print("    <");
                str = this.s_decimalFormat11.format(this.h_minimum);
            } else if (i == this.h_numBuckets + 1) {
                s.print("   >=");
                str = this.s_decimalFormat11.format(this.h_minimum + (double)this.h_numBuckets * this.h_increment);
            } else {
                s.print("     ");
                str = this.s_decimalFormat11.format(this.h_minimum + (double)(i - 1) * this.h_increment);
            }
            s.print(Align.right(str, 11));
            s.print("     ");
            s.print(Align.right(String.valueOf((long)this.h_frequency[i]), 11));
            s.print("     ");
            str = this.s_decimalFormat8.format(proportion);
            s.print(Align.right(str, 8));
            s.print("     ");
            str = this.s_decimalFormat8.format(cumulative);
            s.print(Align.right(str, 8));
            s.print("  ");
            int barLength = maxProportion > 0.0 ? (int)Math.floor(proportion / maxProportion * 20.0 + 0.499999) : 0;
            if (barLength == 0 && proportion > 0.0) {
                s.print(".");
            } else {
                int j = 1;
                while (j <= barLength) {
                    s.print("*");
                    ++j;
                }
                j = barLength + 1;
                while (j < 20) {
                    s.print(" ");
                    ++j;
                }
            }
            s.println("");
            ++i;
        }
        s.println("");
    }

    public void qtable_report(PrintStream s) {
        double proportion;
        double maxProportion = 0.0;
        double cumulative = 0.0;
        int i = 0;
        while (i <= this.h_numBuckets + 1) {
            proportion = this.h_total > 0.0 ? this.h_frequency[i] / this.h_total : 0.0;
            if (proportion > maxProportion) {
                maxProportion = proportion;
            }
            ++i;
        }
        int startBucket = 0;
        int stopBucket = this.h_numBuckets + 1;
        while (startBucket <= stopBucket && this.h_frequency[startBucket] == 0.0) {
            ++startBucket;
        }
        while (stopBucket >= startBucket && this.h_frequency[stopBucket] == 0.0) {
            --stopBucket;
        }
        if (startBucket == stopBucket && stopBucket <= this.h_numBuckets) {
            ++stopBucket;
        }
        s.println("                                            cumulative");
        s.println("     number      total time    proportion   proportion");
        this.s_decimalFormat11 = new DecimalFormat("####0.00000");
        this.s_decimalFormat8 = new DecimalFormat("0.000000");
        this.s_intFormat = new DecimalFormat("0");
        cumulative = 0.0;
        i = startBucket;
        while (i <= stopBucket) {
            String str;
            proportion = this.h_total > 0.0 ? this.h_frequency[i] / this.h_total : 0.0;
            cumulative += proportion;
            if (i == 0) {
                s.print("    <");
                str = this.s_intFormat.format(this.h_minimum);
            } else if (i == this.h_numBuckets + 1) {
                s.print("   >=");
                str = this.s_intFormat.format(this.h_minimum + (double)this.h_numBuckets * this.h_increment);
            } else {
                s.print("     ");
                str = this.s_intFormat.format(this.h_minimum + (double)(i - 1) * this.h_increment);
            }
            s.print(Align.right(str, 5));
            s.print("      ");
            str = this.s_decimalFormat11.format(this.h_frequency[i]);
            s.print(Align.right(str, 11));
            s.print("      ");
            str = this.s_decimalFormat8.format(proportion);
            s.print(Align.right(str, 8));
            s.print("     ");
            str = this.s_decimalFormat8.format(cumulative);
            s.print(Align.right(str, 8));
            s.print("  ");
            int barLength = maxProportion > 0.0 ? (int)Math.floor(proportion / maxProportion * 20.0 + 0.499999) : 0;
            if (barLength == 0 && proportion > 0.0) {
                s.print(".");
            } else {
                int j = 1;
                while (j <= barLength) {
                    s.print("*");
                    ++j;
                }
                j = barLength + 1;
                while (j < 20) {
                    s.print(" ");
                    ++j;
                }
            }
            s.println("");
            ++i;
        }
        s.println("");
    }
}

