/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.csim;

import com.mesquite.csim.AbstractResource;
import com.mesquite.csim.FacilityStats;
import com.mesquite.csim.Model;
import com.mesquite.csim.Process;
import com.mesquite.csim.ProcessClass;
import com.mesquite.csim.ProcessQueue;
import com.mesquite.csim.Server;
import com.mesquite.csim.ServerStats;
import com.mesquite.queue.HeapPriorityQueue;
import com.mesquite.queue.PriorityQueue;
import com.mesquite.text.Align;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Facility
extends AbstractResource {
    protected final Server[] servers;
    protected final ProcessQueue waitQueue;
    private final String m_type;
    private double m_startTime;
    private int m_numServers;
    private final PriorityQueue m_freeServers = new HeapPriorityQueue(s_freeComparator);
    private final PriorityQueue m_busyServers = new HeapPriorityQueue(s_busyComparator);
    private final HashMap m_proc2server = new HashMap();
    private int m_preemptCount = 0;
    protected static final double EPS = 1.0E-6;
    protected final Stats m_stats;
    protected Map m_classStats;
    private static final Comparator s_busyComparator;
    private static final Comparator s_freeComparator;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.mesquite.csim.Facility");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        s_busyComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                Server s1 = (Server)o1;
                Server s2 = (Server)o2;
                if (!$assertionsDisabled && s1 == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && s2 == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && s1.process() == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && s2.process() == null) {
                    throw new AssertionError();
                }
                return s2.process().priority() - s1.process().priority();
            }
        };
        s_freeComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                Server s1 = (Server)o1;
                Server s2 = (Server)o2;
                return s2.index() - s1.index();
            }
        };
    }

    protected Facility(String type, int numServers) {
        this("def", type, numServers);
    }

    protected Facility(String name, String type, int numServers) {
        this(name, type, numServers, Model.currentModel());
    }

    protected Facility(String name, String type, int numServers, Model model) {
        super("facility", name, model);
        Object s;
        this.m_type = type;
        this.m_numServers = numServers;
        this.m_stats = new Stats(null);
        this.m_startTime = model.clock();
        this.waitQueue = new ProcessQueue();
        this.servers = new Server[numServers];
        int i = 0;
        while (i < this.m_numServers) {
            s = new Server(this, i);
            this.servers[i] = s;
            this.m_freeServers.add(s);
            ++i;
        }
        this.reset();
        if (model.traceEnabled()) {
            Process p = model.getActiveProcess();
            s = "init facility " + this.name() + " with " + numServers + " server(s)";
            model.traceEvent(p, (String)s);
        }
    }

    public void collect() {
        if (this.m_classStats == null) {
            this.m_classStats = new HashMap();
            int i = 0;
            while (i < this.m_numServers) {
                this.servers[i].collect();
                ++i;
            }
        }
    }

    public final int numServers() {
        return this.m_numServers;
    }

    public Server server(int n) {
        if (n <= this.m_numServers) {
            return this.servers[n];
        }
        return null;
    }

    public Set processClasses() {
        if (this.m_classStats != null) {
            return Collections.unmodifiableSet(this.m_classStats.keySet());
        }
        return Collections.unmodifiableSet(new HashSet());
    }

    public final ServerStats serverStats(int index) {
        Server s = this.servers[index];
        return s.stats();
    }

    public final FacilityStats stats(ProcessClass cl) {
        return (FacilityStats)this.m_classStats.get(cl);
    }

    public final String type() {
        return this.m_type;
    }

    public int num_busy() {
        int result = 0;
        int i = 0;
        while (i < this.m_numServers) {
            result += this.servers[i].isBusy() ? 1 : 0;
            ++i;
        }
        return result;
    }

    public int qlength() {
        return this.waitQueue.size();
    }

    public int num_servers() {
        return this.m_numServers;
    }

    public String service_disp() {
        return this.m_type;
    }

    protected abstract void useFunc(double var1);

    public void use(double interval) {
        String str = Model.s_timeFormat.format(interval);
        if (this.model().traceEnabled()) {
            this.model().traceEvent("use facility " + this.name() + " for " + str);
        }
        this.useFunc(interval);
    }

    public void reset() {
        this.waitQueue.reset();
        int i = 0;
        while (i < this.m_numServers) {
            this.servers[i].reset();
            ++i;
        }
        this.m_stats.reset();
        if (this.m_classStats != null && !this.m_classStats.isEmpty()) {
            Iterator it = this.m_classStats.keySet().iterator();
            while (it.hasNext()) {
                ProcessClass cl = (ProcessClass)it.next();
                Stats stats = (Stats)this.m_classStats.get(cl);
                stats.reset();
            }
        }
        this.m_startTime = this.model().clock();
    }

    public FacilityStats stats() {
        return this.m_stats;
    }

    protected Server findServer(Process p) {
        return (Server)this.m_proc2server.get(p);
    }

    protected Server xreserve(Process p) {
        this.m_stats.enter();
        Stats classStats = null;
        if (this.m_classStats != null) {
            ProcessClass cl = p.getProcessClass();
            classStats = (Stats)this.m_classStats.get(cl);
            if (classStats == null) {
                classStats = new Stats(cl);
                this.m_classStats.put(cl, classStats);
            }
            classStats.enter();
        }
        if (this.m_freeServers.isEmpty()) {
            p.rtime = 0.0;
            this.waitQueue.add(p);
            this.m_stats.addWaiting();
            if (classStats != null) {
                classStats.addWaiting();
            }
            return null;
        }
        Server s = (Server)this.m_freeServers.remove();
        this.assignServer(s, p);
        this.m_stats.addBusy();
        if (classStats != null) {
            classStats.addBusy();
        }
        return s;
    }

    protected void xrelease() {
        Process p = this.model().getActiveProcess();
        this.xrelease(p);
    }

    protected void xrelease(int idx) {
        Process p = this.model().getActiveProcess();
        Server s = this.servers[idx];
        this.xrelease(p, s);
    }

    protected void xrelease(Process p) {
        Server s = (Server)this.m_proc2server.get(p);
        this.xrelease(p, s);
    }

    protected void xrelease(Process p, Server s) {
        Stats classStats = null;
        this.freeServer(s);
        this.m_stats.removeBusy();
        this.m_stats.exit();
        if (this.m_classStats != null) {
            classStats = (Stats)this.m_classStats.get(p.getProcessClass());
            if (!$assertionsDisabled && classStats == null) {
                throw new AssertionError();
            }
            classStats.removeBusy();
            classStats.exit();
        }
        if (!this.waitQueue.isEmpty()) {
            Process next = this.waitQueue.remove();
            this.m_stats.removeWaiting();
            this.m_stats.addBusy();
            if (this.m_classStats != null) {
                Stats nextClassStats = (Stats)this.m_classStats.get(next.getProcessClass());
                if (!$assertionsDisabled && nextClassStats == null) {
                    throw new AssertionError();
                }
                nextClassStats.removeWaiting();
                nextClassStats.addBusy();
            }
            if (this.model().traceEnabled()) {
                this.model().traceEvent("dequeue facility " + next.name());
            }
            if (this.model().hasEvent(next)) {
                this.model().cancel(next);
            }
            this.assignServer(s, next);
            this.model().schedule(next.rtime, next);
        } else {
            this.m_freeServers.add(s);
        }
    }

    protected boolean preemptResume(Process p, double priority, double interval) {
        ProcessClass clp;
        if (!this.m_freeServers.isEmpty()) {
            this.xreserve(p);
            return true;
        }
        if (!$assertionsDisabled && this.m_busyServers.isEmpty()) {
            throw new AssertionError();
        }
        Server s = (Server)this.m_busyServers.element();
        Stats classStats_p = null;
        if (this.m_classStats != null && (classStats_p = (Stats)this.m_classStats.get(clp = p.getProcessClass())) == null) {
            classStats_p = new Stats(clp);
            this.m_classStats.put(clp, classStats_p);
        }
        if (priority <= (double)s.process().priority()) {
            if (this.model().traceEnabled()) {
                this.model().traceEvent("facility " + this.name() + ", " + p.name() + p.identity() + " enqueued");
            }
            this.m_stats.addWaiting();
            if (classStats_p != null) {
                classStats_p.addWaiting();
            }
            p.rtime = interval;
            this.waitQueue.add(p);
            return false;
        }
        Process user = s.process();
        this.freeServer(s);
        this.m_stats.removeBusy();
        Stats classStats_user = null;
        if (this.m_classStats != null) {
            ProcessClass clu = user.getProcessClass();
            classStats_user = (Stats)this.m_classStats.get(clu);
            if (classStats_user == null) {
                classStats_user = new Stats(clu);
                this.m_classStats.put(clu, classStats_user);
            }
            classStats_user.removeBusy();
        }
        Model.EventItem ev = this.model().cancel(user);
        double rtime = ev.time - this.model().clock();
        if (rtime == 0.0) {
            rtime = 1.0E-30;
        }
        user.rtime = rtime;
        if (this.model().traceEnabled()) {
            this.model().traceEvent("facility " + this.name() + ", " + user.name() + user.identity() + " preempted");
        }
        this.waitQueue.add(user);
        this.m_stats.addWaiting();
        if (classStats_user != null) {
            classStats_user.addWaiting();
        }
        ++this.m_preemptCount;
        if (this.model().traceEnabled()) {
            this.model().traceEvent("facility " + this.name() + ", " + p.name() + p.identity() + " assigned server");
        }
        this.assignServer(s, p);
        this.m_stats.addBusy();
        if (classStats_p != null) {
            classStats_p.addBusy();
        }
        return true;
    }

    public void dumpStatus(PrintStream out) {
        out.print(Align.left(this.name(), 14));
        out.print(String.valueOf(Align.right(String.valueOf(this.num_busy()), 2)) + " of " + Align.right(String.valueOf(this.numServers()), 2));
        out.print(Align.right(String.valueOf(this.qlength()), 4));
        out.print("    serv: ");
        int i = 0;
        while (i < this.numServers()) {
            if (this.servers[i].isBusy()) {
                Process p = this.servers[i].process();
                out.print(String.valueOf(p.name()) + "." + String.valueOf(p.identity()) + "  ");
            }
            ++i;
        }
        out.println();
        out.print("                             queue: ");
        LinkedList<Process> look = new LinkedList<Process>();
        int n = 0;
        while (!this.waitQueue.isEmpty()) {
            if (n >= 6) {
                out.println();
                out.println("                                    ");
                n = 0;
            }
            Process p = this.waitQueue.remove();
            look.add(p);
            out.print(String.valueOf(p.name()) + "." + String.valueOf(p.identity()) + "  ");
            ++n;
        }
        if (look.isEmpty() || n > 0) {
            out.println();
        }
        Iterator it = look.iterator();
        while (it.hasNext()) {
            this.waitQueue.add((Process)it.next());
        }
    }

    public ProcessQueue getQueue() {
        return this.waitQueue;
    }

    public Process first_process() {
        return this.waitQueue.peek();
    }

    public Process remove_first_process() {
        Process p;
        if (!this.waitQueue.isEmpty()) {
            p = this.waitQueue.remove();
            if (p != null) {
                this.m_stats.removeWaiting();
                if (this.model().traceEnabled()) {
                    this.model().traceEvent("remove " + p.name() + "." + p.identity());
                }
            }
        } else {
            p = null;
        }
        return p;
    }

    public Process last_process() {
        if (!this.waitQueue.isEmpty()) {
            return this.waitQueue.lastProcess();
        }
        return null;
    }

    public List process_list() {
        LinkedList<Process> pList = new LinkedList<Process>();
        while (!this.waitQueue.isEmpty()) {
            pList.add(this.waitQueue.remove());
        }
        Iterator it = pList.iterator();
        while (it.hasNext()) {
            this.waitQueue.add((Process)it.next());
        }
        return pList;
    }

    public Process remove_process(Process pr) {
        this.waitQueue.remove(pr);
        this.m_stats.removeWaiting();
        if (this.model().traceEnabled()) {
            this.model().traceEvent("remove " + pr.name() + "." + pr.identity());
        }
        return pr;
    }

    public void insert_process(Process p) {
        Server s;
        if (this.model().traceEnabled()) {
            this.model().traceEvent("insert " + p.name() + "." + p.identity());
        }
        if ((s = this.xreserve(p)) != null) {
            this.model().schedule(p.rtime, p);
        }
    }

    public List processList() {
        LinkedList<Process> pList = new LinkedList<Process>();
        while (!this.waitQueue.isEmpty()) {
            pList.add(this.waitQueue.remove());
        }
        Iterator it = pList.iterator();
        while (it.hasNext()) {
            this.waitQueue.add((Process)it.next());
        }
        return pList;
    }

    private void assignServer(Server s, Process p) {
        s.assign(p);
        this.m_proc2server.put(p, s);
        this.m_busyServers.add(s);
    }

    private void freeServer(Server s) {
        if (s == null) {
            throw new RuntimeException("facility: tried to free unassigned server");
        }
        this.m_busyServers.remove(s);
        this.m_proc2server.remove(s);
        s.release();
    }

    protected final class Stats
    implements FacilityStats {
        private double m_resetTime;
        private ProcessClass m_processClass;
        private int m_completions = 0;
        private int m_numActive = 0;
        private int m_busyNum = 0;
        private double m_busySum = 0.0;
        private double m_busyLastChange;
        private int m_waitNum = 0;
        private double m_waitSum = 0.0;
        private double m_waitLastChange;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.mesquite.csim.Facility$Stats");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        protected Stats(ProcessClass cl) {
            this.m_processClass = cl;
            double clock = Facility.this.model().clock();
            this.m_resetTime = Facility.this.model().beginTime();
            this.m_busyLastChange = clock;
            this.m_waitLastChange = clock;
        }

        public double busyTime() {
            return this.m_busySum;
        }

        public int completions() {
            return this.m_completions;
        }

        public double elapsedTime() {
            return Facility.this.model().clock() - this.m_resetTime;
        }

        public ProcessClass processClass() {
            return this.m_processClass;
        }

        public double queueLength() {
            if (this.elapsedTime() > 0.0) {
                return (this.waitingTime() + this.busyTime()) / this.elapsedTime();
            }
            return 0.0;
        }

        public double responseTime() {
            if (this.completions() > 0) {
                return (this.waitingTime() + this.busyTime()) / (double)this.completions();
            }
            return 0.0;
        }

        public double serviceTime() {
            if (this.completions() > 0) {
                return this.busyTime() / (double)this.completions();
            }
            return 0.0;
        }

        public double throughput() {
            if (this.elapsedTime() > 0.0) {
                return (double)this.completions() / this.elapsedTime();
            }
            return 0.0;
        }

        public double utilization() {
            if (this.elapsedTime() > 0.0) {
                return this.busyTime() / this.elapsedTime();
            }
            return 0.0;
        }

        public double waitingTime() {
            this.updateWait();
            return this.m_waitSum;
        }

        protected void reset() {
            double clock = Facility.this.model().clock();
            this.m_completions = 0;
            this.m_resetTime = clock;
            this.m_busySum = 0.0;
            this.m_busyLastChange = clock;
            this.m_waitSum = 0.0;
            this.m_waitLastChange = clock;
        }

        protected void enter() {
            ++this.m_numActive;
        }

        protected void exit() {
            if (!$assertionsDisabled && this.m_numActive <= 0) {
                throw new AssertionError();
            }
            --this.m_numActive;
            ++this.m_completions;
        }

        protected void exitWaiting() {
            if (!$assertionsDisabled && this.m_numActive <= 0) {
                throw new AssertionError();
            }
            --this.m_waitNum;
            this.updateWait();
        }

        protected void abort() {
            if (!$assertionsDisabled && this.m_numActive <= 0) {
                throw new AssertionError();
            }
            --this.m_numActive;
        }

        public int count() {
            return this.m_numActive;
        }

        protected void addBusy() {
            if (!$assertionsDisabled && this.m_busyNum >= this.m_numActive) {
                throw new AssertionError();
            }
            this.updateBusy();
            ++this.m_busyNum;
        }

        protected void removeBusy() {
            if (!$assertionsDisabled && this.m_busyNum <= 0) {
                throw new AssertionError();
            }
            this.updateBusy();
            --this.m_busyNum;
        }

        protected void addWaiting() {
            if (!$assertionsDisabled && this.m_waitNum >= this.m_numActive) {
                throw new AssertionError();
            }
            this.updateWait();
            ++this.m_waitNum;
        }

        protected void removeWaiting() {
            if (!$assertionsDisabled && this.m_waitNum <= 0) {
                throw new AssertionError();
            }
            this.updateWait();
            --this.m_waitNum;
        }

        private void updateBusy() {
            double clock = Facility.this.model().clock();
            this.m_busySum += (double)this.m_busyNum * (clock - this.m_busyLastChange);
            this.m_busyLastChange = clock;
        }

        private void updateWait() {
            double clock = Facility.this.model().clock();
            this.m_waitSum += (double)this.m_waitNum * (clock - this.m_waitLastChange);
            this.m_waitLastChange = clock;
        }

        protected void removeInfBusy(double t) {
            this.m_busySum += t;
            ++this.m_completions;
        }
    }
}

