/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.csim;

import com.mesquite.csim.Facility;
import com.mesquite.csim.Model;
import com.mesquite.csim.Process;
import com.mesquite.csim.Server;

public class FCFSFacility
extends Facility {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.mesquite.csim.FCFSFacility");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public FCFSFacility() {
        this("def");
    }

    public FCFSFacility(String name) {
        this(name, 1);
    }

    public FCFSFacility(String name, int numServers) {
        super(name, "fcfs", numServers);
    }

    public void release() {
        this.model().checkThread();
        if (this.model().traceEnabled()) {
            this.model().traceEvent("release facility " + this.name());
        }
        this.xrelease();
    }

    public void release(int idx) {
        this.model().checkThread();
        if (this.model().traceEnabled()) {
            this.model().traceEvent("release facility " + this.name() + " server " + idx);
        }
        this.xrelease(idx);
    }

    public int reserve() {
        Server s;
        this.model().checkThread();
        Process p = this.model().getActiveProcess();
        if (this.model().traceEnabled()) {
            this.model().traceEvent("reserve facility " + this.name());
        }
        if ((s = this.xreserve(p)) == null) {
            p.suspendAndFire();
            s = this.findServer(p);
        }
        if (s == null) {
            return -1;
        }
        return s.index();
    }

    public int timed_reserve(double timeout) {
        Process p = this.model().getActiveProcess();
        this.model().checkThread();
        if (this.model().traceEnabled()) {
            String str = Model.s_timeFormat.format(timeout);
            this.model().traceEvent("timed reserve: " + this.name() + " " + str);
        }
        this.model().schedule(timeout);
        int result = this.reserve();
        if (p.queue() != null) {
            if (!$assertionsDisabled && this.model().hasEvent(p)) {
                throw new AssertionError();
            }
            if (this.model().traceEnabled()) {
                this.model().traceEvent("timed out at " + this.name());
            }
            this.waitQueue.remove(p);
            result = -1;
        } else {
            if (this.model().traceEnabled()) {
                this.model().traceEvent("timed_reserve " + this.name());
            }
            if (this.model().hasEvent(p)) {
                this.model().cancel(p);
            }
        }
        return result;
    }

    public void useFunc(double interval) {
        Process p = this.model().getActiveProcess();
        this.reserve();
        p.hold(interval);
        this.release();
    }
}

