/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.csim;

import com.mesquite.csim.Event;
import com.mesquite.csim.Model;
import com.mesquite.csim.Process;

public class EventSet {
    public static final int TIMED_OUT = -1;
    private String m_name;
    private final Model m_model;
    private final Event[] m_events;
    private final Event m_setEvent;
    private int m_numSets = 0;
    private static final boolean s_debug = false;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.mesquite.csim.EventSet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public EventSet(String name, int numEvents) {
        this.m_name = name;
        this.m_model = Model.currentModel();
        if (this.m_model.traceEnabled()) {
            this.m_model.traceEvent("create event set " + name);
        }
        this.m_setEvent = new Event(String.valueOf(name) + ".set");
        this.m_events = new Event[numEvents];
        int i = 0;
        while (i < numEvents) {
            Event e;
            this.m_events[i] = e = new Event(String.valueOf(name) + "[" + i + "]");
            e.assignSet(this, i);
            ++i;
        }
    }

    public EventSet(String name, Event[] events) {
        this.m_name = name;
        this.m_model = Model.currentModel();
        if (this.m_model.traceEnabled()) {
            this.m_model.traceEvent("create event set " + name);
        }
        this.m_setEvent = new Event(String.valueOf(name) + ".set");
        this.m_events = events;
        int i = 0;
        while (i < this.m_events.length) {
            this.m_events[i].assignSet(this, i);
            ++i;
        }
    }

    public Event get(int index) {
        return this.m_events[index];
    }

    public Model model() {
        return this.m_model;
    }

    public String name() {
        return this.m_name;
    }

    public void reset() {
        this.m_setEvent.reset();
        int i = 0;
        while (i < this.m_events.length) {
            this.m_events[i].reset();
            ++i;
        }
    }

    public void monitor() {
        this.m_setEvent.monitor();
        int i = 0;
        while (i < this.m_events.length) {
            this.m_events[i].monitor();
            ++i;
        }
    }

    public int queue_any() {
        int index = -1;
        this.sanityCheck();
        if (this.m_model.traceEnabled()) {
            this.m_model.traceEvent("queue any event " + this.name());
        }
        if (!this.m_setEvent.occurred()) {
            Process p = this.m_model.getActiveProcess();
            this.m_setEvent.queue();
            index = p.eventIndex;
        } else {
            index = this.findAndClearEvent();
        }
        this.sanityCheck();
        if (this.m_model.traceEnabled()) {
            this.m_model.traceEvent("set " + this.name() + ", event " + index + " recognized");
        }
        return index;
    }

    public int timed_queue_any(double timeout) {
        Process p = this.m_model.getActiveProcess();
        this.sanityCheck();
        if (this.m_model.traceEnabled()) {
            String str = Model.s_timeFormat.format(timeout);
            this.m_model.traceEvent("timed queue any: " + this.name() + " " + str);
        }
        this.m_model.schedule(timeout);
        int index = this.queue_any();
        if (p.queue() != null) {
            if (!$assertionsDisabled && this.m_model.hasEvent(p)) {
                throw new AssertionError();
            }
            if (this.m_model.traceEnabled()) {
                this.m_model.traceEvent("timed out at " + this.m_setEvent.name());
            }
            this.m_setEvent.removeQueue(p);
            index = -1;
        } else {
            if (this.m_model.traceEnabled()) {
                this.m_model.traceEvent("timed_q recog evt " + this.m_setEvent.name());
            }
            if (this.m_model.hasEvent(p)) {
                this.m_model.cancel(p);
            }
        }
        this.sanityCheck();
        return index;
    }

    public int timed_wait_any(double timeout) {
        Process p = this.m_model.getActiveProcess();
        this.sanityCheck();
        if (this.m_model.traceEnabled()) {
            String str = Model.s_timeFormat.format(timeout);
            this.m_model.traceEvent("timed wait any: " + this.name() + " " + str);
        }
        this.m_model.schedule(timeout);
        int index = this.wait_any();
        if (p.queue() != null) {
            if (!$assertionsDisabled && this.m_model.hasEvent(p)) {
                throw new AssertionError();
            }
            if (this.m_model.traceEnabled()) {
                this.m_model.traceEvent("timed out at " + this.m_setEvent.name());
            }
            this.m_setEvent.removeWait(p);
            index = -1;
        } else {
            if (this.m_model.traceEnabled()) {
                this.m_model.traceEvent("timed_w recog evt " + this.m_setEvent.name());
            }
            if (this.m_model.hasEvent(p)) {
                this.m_model.cancel(p);
            }
        }
        this.sanityCheck();
        return index;
    }

    public int wait_any() {
        int index;
        if (this.m_model.traceEnabled()) {
            this.m_model.traceEvent("wait any event " + this.name());
        }
        this.sanityCheck();
        if (!this.m_setEvent.occurred()) {
            Process p = this.m_model.getActiveProcess();
            this.m_setEvent.untimed_wait();
            index = p.eventIndex;
        } else {
            index = this.findAndClearEvent();
        }
        this.sanityCheck();
        if (this.m_model.traceEnabled()) {
            this.m_model.traceEvent("set " + this.name() + ", evnt " + index + " rec");
        }
        return index;
    }

    void onEventClear(Event ev) {
        if (!$assertionsDisabled && this.m_numSets <= 0) {
            throw new AssertionError();
        }
        --this.m_numSets;
        if (this.m_numSets == 0) {
            this.m_setEvent.doClear();
        }
    }

    int onEventSet(Event ev) {
        if (!$assertionsDisabled && this.m_numSets >= this.m_events.length) {
            throw new AssertionError();
        }
        ++this.m_numSets;
        return this.m_setEvent.doSet(ev.index());
    }

    private int findAndClearEvent() {
        int i = 0;
        while (i < this.m_events.length) {
            Event e = this.m_events[i];
            if (e.occurred()) {
                if (e.qlength() == 0) {
                    e.doClear();
                }
                return i;
            }
            ++i;
        }
        throw new IllegalStateException("eventSet: could not find event");
    }

    private void sanityCheck() {
    }
}

