/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.csim;

import com.mesquite.csim.AbstractResource;
import com.mesquite.csim.EventSet;
import com.mesquite.csim.Model;
import com.mesquite.csim.Process;
import com.mesquite.csim.ProcessQueue;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Event
extends AbstractResource {
    private boolean m_occurred = false;
    private int m_setCount = 0;
    private final ProcessQueue m_qQueue;
    private int m_qVisits = 0;
    private final ProcessQueue m_wQueue;
    private int m_wVisits = 0;
    private double m_startTime;
    private boolean m_reportEnabled = false;
    private EventSet m_set = null;
    private int m_setIndex = 0;
    private static final boolean s_debug = false;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.mesquite.csim.Event");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public Event(String name) {
        this(name, Model.currentModel());
    }

    public Event(String name, Model model) {
        super("event", name, model);
        this.m_qQueue = new ProcessQueue(model);
        this.m_wQueue = new ProcessQueue(model);
        this.reset();
        if (model.traceEnabled()) {
            model.traceEvent("create event " + this.name());
        }
    }

    public void monitor() {
        this.m_reportEnabled = true;
    }

    public void collect() {
    }

    public boolean reportEnabled() {
        return this.m_reportEnabled;
    }

    public void reset() {
        this.m_setCount = 0;
        this.m_qVisits = 0;
        this.m_wVisits = 0;
        this.m_startTime = this.model().clock();
        this.m_qQueue.reset();
        this.m_wQueue.reset();
    }

    public void clear() {
        this.doClear();
    }

    public void set() {
        if (this.model().traceEnabled()) {
            this.model().traceEvent("set event " + this.name());
        }
        ++this.m_setCount;
        this.doSet();
    }

    public void untimed_queue() {
        this.queue();
    }

    public void queue() {
        this.model().checkThread();
        Process p = this.model().getActiveProcess();
        if (this.model().traceEnabled()) {
            this.model().traceEvent("queue on event " + this.name());
        }
        ++this.m_qVisits;
        if (!this.m_occurred) {
            this.m_qQueue.add(p);
            p.suspendAndFire();
        } else {
            this.doClear();
        }
        this.sanityCheck();
    }

    public void untimed_wait() {
        this.model().checkThread();
        Process p = this.model().getActiveProcess();
        if (this.model().traceEnabled()) {
            this.model().traceEvent("wait event " + this.name());
        }
        ++this.m_wVisits;
        if (!this.m_occurred) {
            this.m_wQueue.add(p);
            p.suspendAndFire();
        } else {
            this.doClear();
        }
        this.sanityCheck();
    }

    public boolean timed_queue(double timeout) {
        boolean result;
        Process p = this.model().getActiveProcess();
        this.model().checkThread();
        if (this.model().traceEnabled()) {
            String str = Model.s_timeFormat.format(timeout);
            this.model().traceEvent("timed queue: " + this.name() + " " + str);
        }
        this.model().schedule(timeout);
        this.queue();
        if (p.queue() != null) {
            if (!$assertionsDisabled && this.model().hasEvent(p)) {
                throw new AssertionError();
            }
            if (this.model().traceEnabled()) {
                this.model().traceEvent("timed out at " + this.name());
            }
            this.m_qQueue.remove(p);
            result = false;
        } else {
            if (this.model().traceEnabled()) {
                this.model().traceEvent("timed_q recog evt " + this.name());
            }
            if (this.model().hasEvent(p)) {
                this.model().cancel(p);
            }
            result = true;
        }
        this.sanityCheck();
        return result;
    }

    public boolean timed_wait(double timeout) {
        boolean result;
        Process p = this.model().getActiveProcess();
        this.model().checkThread();
        if (this.model().traceEnabled()) {
            String str = Model.s_timeFormat.format(timeout);
            this.model().traceEvent("timed wait: " + this.name() + " " + str);
        }
        this.model().schedule(timeout);
        this.untimed_wait();
        if (p.queue() != null) {
            if (!$assertionsDisabled && this.model().hasEvent(p)) {
                throw new AssertionError();
            }
            if (this.model().traceEnabled()) {
                this.model().traceEvent("timed out at " + this.name());
            }
            this.m_wQueue.remove(p);
            result = false;
        } else {
            if (this.model().traceEnabled()) {
                this.model().traceEvent("timed_w recog evt " + this.name());
            }
            if (this.model().hasEvent(p)) {
                this.model().cancel(p);
            }
            result = true;
        }
        this.sanityCheck();
        return result;
    }

    public boolean occurred() {
        return this.m_occurred;
    }

    public double elapsedTime() {
        return this.model().clock() - this.m_startTime;
    }

    public int qlength() {
        return this.m_wQueue.size() + this.m_qQueue.size();
    }

    public int num_sets() {
        return this.m_setCount;
    }

    public int wait_cnt() {
        return this.m_wQueue.size();
    }

    public int queue_cnt() {
        return this.m_qQueue.size();
    }

    public int wait_visits() {
        return this.m_wVisits;
    }

    public int queue_visits() {
        return this.m_qVisits;
    }

    public double wait_sum() {
        return this.m_wQueue.waitTime();
    }

    public double queue_sum() {
        return this.m_qQueue.waitTime();
    }

    public double queue_len() {
        if (this.elapsedTime() > 0.0) {
            return this.queue_sum() / this.elapsedTime();
        }
        return 0.0;
    }

    public double wait_len() {
        if (this.elapsedTime() > 0.0) {
            return this.wait_sum() / this.elapsedTime();
        }
        return 0.0;
    }

    public double wait_time() {
        if (this.wait_visits() > 0) {
            return this.wait_sum() / (double)this.wait_visits();
        }
        return 0.0;
    }

    public double queue_time() {
        if (this.queue_visits() > 0) {
            return this.queue_sum() / (double)this.queue_visits();
        }
        return 0.0;
    }

    public ProcessQueue getWaitQueue() {
        return this.m_wQueue;
    }

    public ProcessQueue getQueueQueue() {
        return this.m_qQueue;
    }

    public Process first_queue_process() {
        return this.m_qQueue.peek();
    }

    public Process last_queue_process() {
        if (!this.m_qQueue.isEmpty()) {
            return this.m_qQueue.lastProcess();
        }
        return null;
    }

    public Process remove_queue_process(Process pr) {
        if (!this.m_qQueue.isEmpty()) {
            this.m_qQueue.remove(pr);
            if (this.model().traceEnabled()) {
                this.model().traceEvent("event.queue " + this.name() + " remove " + pr.name() + "." + pr.identity());
            }
            return pr;
        }
        return null;
    }

    public void insert_queue_process(Process pr) {
        if (this.model().traceEnabled()) {
            this.model().traceEvent("event.queue " + this.name() + " insert " + pr.name() + "." + pr.identity());
        }
        this.m_qQueue.add(pr);
    }

    public List queue_process_list() {
        LinkedList<Process> pList = new LinkedList<Process>();
        while (!this.m_qQueue.isEmpty()) {
            pList.add(this.m_qQueue.remove());
        }
        Iterator it = pList.iterator();
        while (it.hasNext()) {
            this.m_qQueue.add((Process)it.next());
        }
        return pList;
    }

    public Process first_wait_process() {
        return this.m_wQueue.peek();
    }

    public Process last_wait_process() {
        if (!this.m_wQueue.isEmpty()) {
            return this.m_wQueue.lastProcess();
        }
        return null;
    }

    public Process remove_wait_process(Process pr) {
        if (!this.m_wQueue.isEmpty()) {
            this.m_wQueue.remove(pr);
            if (this.model().traceEnabled()) {
                this.model().traceEvent("event.waitq " + this.name() + " remove " + pr.name() + "." + pr.identity());
            }
            return pr;
        }
        return null;
    }

    public void insert_wait_process(Process pr) {
        if (this.model().traceEnabled()) {
            this.model().traceEvent("event.waitq " + this.name() + " insert " + pr.name() + "." + pr.identity());
        }
        this.m_wQueue.add(pr);
    }

    public List wait_process_list() {
        LinkedList<Process> pList = new LinkedList<Process>();
        while (!this.m_wQueue.isEmpty()) {
            pList.add(this.m_wQueue.remove());
        }
        Iterator it = pList.iterator();
        while (it.hasNext()) {
            this.m_wQueue.add((Process)it.next());
        }
        return pList;
    }

    void assignSet(EventSet set, int index) {
        this.m_set = set;
        this.m_setIndex = index;
    }

    void removeQueue(Process p) {
        this.m_qQueue.remove(p);
    }

    void removeWait(Process p) {
        this.m_wQueue.remove(p);
    }

    void doClear() {
        if (this.m_occurred) {
            this.m_occurred = false;
            if (this.m_set != null) {
                this.m_set.onEventClear(this);
            }
        }
        this.sanityCheck();
    }

    int doSet() {
        return this.doSet(-1);
    }

    int doSet(int index) {
        Process p;
        int numResumes = 0;
        if (!this.m_qQueue.isEmpty()) {
            p = this.m_qQueue.remove();
            if (index >= 0) {
                p.eventIndex = index;
                if (this.model().traceEnabled()) {
                    this.model().traceEvent(p, "recog3 evt " + this.name());
                }
            } else if (this.model().traceEnabled()) {
                this.model().traceEvent(p, "recog1 evt " + this.name());
            }
            this.model().reschedule(0.0, p);
            if (!$assertionsDisabled && !this.model().hasEvent(p)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && p.queue() != null) {
                throw new AssertionError();
            }
            ++numResumes;
        }
        while (!this.m_wQueue.isEmpty()) {
            p = this.m_wQueue.remove();
            if (index >= 0) {
                p.eventIndex = index;
                if (this.model().traceEnabled()) {
                    this.model().traceEvent(p, "recog4 evt " + this.name());
                }
            } else if (this.model().traceEnabled()) {
                this.model().traceEvent(p, "recog2 evt " + this.name());
            }
            this.model().reschedule(0.0, p);
            if (!$assertionsDisabled && !this.model().hasEvent(p)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && p.queue() != null) {
                throw new AssertionError();
            }
            ++numResumes;
        }
        if (this.m_set != null && !this.m_occurred) {
            numResumes += this.m_set.onEventSet(this);
        }
        this.m_occurred = true;
        if (numResumes > 0) {
            this.doClear();
        }
        this.sanityCheck();
        return numResumes;
    }

    int index() {
        return this.m_setIndex;
    }

    private void sanityCheck() {
    }
}

