/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.csim;

import com.mesquite.csim.BasicQTable;
import com.mesquite.csim.BasicTable;
import java.io.PrintStream;
import java.text.DecimalFormat;

public class ConfidenceInterval {
    private PrintStream m_output;
    private BasicTable m_table;
    private int m_batchSize;
    private int m_obsCount;
    private double m_sumObs;
    private BasicQTable m_qtable;
    private double m_batchTime;
    private double m_nextBatch;
    private double m_prevSum;
    private double[] m_batchMean;
    private int m_batchCount;
    private double m_sumOfMeans;
    private double m_sumSqOfMeans;
    private boolean m_converged;
    private boolean m_hasRunLength;
    private double m_confLevel;
    private double m_accuracy;
    private double m_maxCpuTime;
    private double m_meanOfMeans;
    private double m_varOfMeans;
    private double m_halfWidth;
    private double m_relError;
    private static final int initial_batch_size = 100;
    private static final int max_lags = 5;
    private static final boolean trace_bma = false;
    private static final double initial_batch_time = 100.0;
    private static final DecimalFormat s_format6 = new DecimalFormat("##0.000000");
    private static final DecimalFormat s_format4 = new DecimalFormat("##0.0000");
    private static final DecimalFormat s_format1;
    private static final DecimalFormat s_format2;
    private static final DecimalFormat s_format0;

    static {
        s_format2 = new DecimalFormat("##.00");
        s_format1 = new DecimalFormat("#00.0");
        s_format0 = new DecimalFormat("##0");
    }

    public ConfidenceInterval(BasicTable table) {
        this.m_table = table;
        this.m_qtable = null;
        this.m_output = this.m_table.model().getOutputStream();
        this.m_table.count();
        this.m_batchMean = new double[51];
        this.initializeTable();
        this.m_confLevel = 0.95;
        this.m_accuracy = 0.0;
        this.m_hasRunLength = false;
    }

    public ConfidenceInterval(BasicQTable qtable) {
        this.m_qtable = qtable;
        this.m_table = null;
        this.m_output = this.m_qtable.model().getOutputStream();
        this.m_qtable.entries();
        this.m_batchMean = new double[51];
        this.initializeQtable();
        this.m_confLevel = 0.95;
        this.m_accuracy = 0.0;
        this.m_hasRunLength = false;
    }

    public void addRunLength(double accuracy, double confLevel, double maxCpuTime) {
        if (!(accuracy <= 0.0)) {
            // empty if block
        }
        if (!(confLevel <= 0.0)) {
            // empty if block
        }
        this.m_accuracy = accuracy;
        this.m_confLevel = confLevel;
        this.m_maxCpuTime = maxCpuTime;
        this.m_hasRunLength = true;
    }

    private void initializeTable() {
        this.m_batchSize = 100;
        this.m_obsCount = 0;
        this.m_batchCount = 0;
        this.m_sumOfMeans = 0.0;
        this.m_sumSqOfMeans = 0.0;
        this.m_converged = false;
    }

    private void initializeQtable() {
        this.m_batchTime = 100.0;
        this.m_nextBatch = this.m_qtable.model().clock() + this.m_batchTime;
        this.m_batchCount = 0;
        this.m_prevSum = 0.0;
        this.m_sumOfMeans = 0.0;
        this.m_sumSqOfMeans = 0.0;
        this.m_converged = false;
    }

    public void reset() {
        if (this.m_table != null) {
            this.initializeTable();
        } else if (this.m_qtable != null) {
            this.initializeQtable();
        }
    }

    public int batchSize() {
        return this.m_batchSize;
    }

    public double batchTime() {
        return this.m_batchTime;
    }

    public int batchCount() {
        return this.m_batchCount;
    }

    public double accuracy() {
        return this.m_accuracy;
    }

    public boolean converged() {
        return this.m_converged;
    }

    public double meanOfMeans(double confLevel) {
        if (confLevel <= 0.0 || confLevel >= 1.0) {
            return 0.0;
        }
        if (this.m_batchCount < 50) {
            return 0.0;
        }
        this.computeConfidenceStatistics(confLevel);
        return this.m_meanOfMeans;
    }

    public double halfWidth(double confLevel) {
        if (confLevel <= 0.0 || confLevel >= 1.0) {
            return 0.0;
        }
        if (this.m_batchCount < 50) {
            return 0.0;
        }
        this.computeConfidenceStatistics(confLevel);
        return this.m_halfWidth;
    }

    public double lower(double confLevel) {
        if (confLevel <= 0.0 || confLevel >= 1.0) {
            return 0.0;
        }
        if (this.m_batchCount < 50) {
            return 0.0;
        }
        this.computeConfidenceStatistics(confLevel);
        return this.m_meanOfMeans - this.m_halfWidth;
    }

    public double upper(double confLevel) {
        if (confLevel <= 0.0 || confLevel >= 1.0) {
            return 0.0;
        }
        if (this.m_batchCount < 50) {
            return 0.0;
        }
        this.computeConfidenceStatistics(confLevel);
        return this.m_meanOfMeans + this.m_halfWidth;
    }

    public double relativeError(double confLevel) {
        if (confLevel <= 0.0 || confLevel >= 1.0) {
            return 0.0;
        }
        if (this.m_batchCount < 50) {
            return 0.0;
        }
        this.computeConfidenceStatistics(confLevel);
        return this.m_relError;
    }

    public void report(PrintStream s) {
        s.println();
        if (this.m_hasRunLength) {
            this.reportRunLength(s);
        } else {
            this.reportConfidence(s);
        }
    }

    public void reportConfidence(PrintStream s) {
        String str;
        if (this.m_table != null) {
            str = s_format0.format(this.m_batchCount * this.m_batchSize);
            s.println("      confidence intervals for the mean after " + str + " observations");
        } else if (this.m_qtable != null) {
            str = s_format1.format((double)this.m_batchCount * this.m_batchTime);
            s.println("      confidence intervals for the mean after " + str + " time units");
        }
        s.println();
        if (this.m_batchCount < 50) {
            s.println("      > insufficient observations to compute confidence intervals");
            return;
        }
        s.println("     level            confidence interval                      rel. error");
        s.println();
        int i = 0;
        while (i < 3) {
            this.m_confLevel = i == 0 ? 0.9 : (i == 1 ? 0.95 : 0.98);
            this.computeConfidenceStatistics(this.m_confLevel);
            String str0 = s_format1.format(this.m_confLevel * 100.0);
            String str1 = s_format6.format(this.m_meanOfMeans);
            String str2 = s_format6.format(this.m_halfWidth);
            String str3 = s_format6.format(this.m_meanOfMeans - this.m_halfWidth);
            String str4 = s_format6.format(this.m_meanOfMeans + this.m_halfWidth);
            String str5 = s_format6.format(this.m_relError);
            s.println("     " + str0 + "%    " + str1 + " +/- " + str2 + " = [" + str3 + ", " + str4 + "]      " + str5);
            ++i;
        }
        s.println();
    }

    public void reportRunLength(PrintStream s) {
        String str2;
        String str1;
        s.println("      results of run length control using confidence intervals");
        s.println();
        if (this.m_batchCount < 50) {
            s.println("      > insufficient observations to compute confidence intervals");
        } else {
            this.computeConfidenceStatistics(this.m_confLevel);
            str1 = s_format1.format(this.m_maxCpuTime);
            str2 = s_format6.format(this.m_accuracy);
            s.println("      cpu time limit " + str1 + "                accuracy requested " + str2);
            str1 = this.m_table != null ? s_format1.format(this.m_table.model().executionTime()) : (this.m_qtable != null ? s_format1.format(this.m_qtable.model().executionTime()) : "");
            str2 = s_format6.format(this.m_relError);
            s.println("      cpu time used  " + str1 + "                accuracy achieved  " + str2);
        }
        s.println();
        if (this.m_relError > this.m_accuracy) {
            s.println("      > warning - requested accuracy has not been achieved");
        } else {
            s.println("      > the requested accuracy has been achieved          ");
        }
        s.println();
        str1 = s_format1.format(this.m_confLevel * 100.0);
        str2 = s_format6.format(this.m_meanOfMeans);
        String str3 = s_format6.format(this.m_halfWidth);
        String str4 = s_format6.format(this.m_meanOfMeans - this.m_halfWidth);
        String str5 = s_format6.format(this.m_meanOfMeans + this.m_halfWidth);
        s.println("      " + str1 + "% confidence interval: " + str2 + " +/- " + str3 + " = [" + str4 + ", " + str5 + "]");
        s.println();
    }

    public void record(double value) {
        ++this.m_obsCount;
        this.m_sumObs += value;
        double thisBatchMean = this.m_sumObs / (double)this.m_batchSize;
        if (this.m_obsCount == this.m_batchSize) {
            ++this.m_batchCount;
            this.endOfBatch(thisBatchMean);
        }
    }

    public void record_change() {
        if (this.m_qtable.model().clock() >= this.m_nextBatch) {
            ++this.m_batchCount;
            double tempSum = this.m_qtable.realSum() + (this.m_nextBatch - this.m_qtable.last_change()) * (double)this.m_qtable.current();
            double thisBatchMean = (tempSum - this.m_prevSum) / this.m_batchTime;
            this.m_prevSum = tempSum;
            this.endOfBatch(thisBatchMean);
            this.m_nextBatch += this.m_batchTime;
        }
    }

    private void endOfBatch(double thisBatchMean) {
        if (this.m_batchCount <= 50) {
            this.m_batchMean[this.m_batchCount] = thisBatchMean;
        }
        this.m_sumOfMeans += thisBatchMean;
        this.m_sumSqOfMeans += thisBatchMean * thisBatchMean;
        this.computeConfidenceStatistics(this.m_confLevel);
        if (this.m_batchCount == 50) {
            this.m_varOfMeans = (this.m_sumSqOfMeans - (double)this.m_batchCount * this.m_meanOfMeans * this.m_meanOfMeans) / (double)(this.m_batchCount - 1);
            if (this.computeCorrelation()) {
                if (this.m_table != null) {
                    this.m_batchSize *= 2;
                } else if (this.m_qtable != null) {
                    this.m_batchTime *= 2.0;
                }
                this.m_batchCount /= 2;
                int j = 1;
                int i = 1;
                while (i <= this.m_batchCount) {
                    this.m_batchMean[i] = (this.m_batchMean[j] + this.m_batchMean[j + 1]) / 2.0;
                    j += 2;
                    ++i;
                }
                this.m_sumOfMeans = 0.0;
                this.m_sumSqOfMeans = 0.0;
                i = 1;
                while (i <= this.m_batchCount) {
                    this.m_sumOfMeans += this.m_batchMean[i];
                    this.m_sumSqOfMeans += this.m_batchMean[i] * this.m_batchMean[i];
                    ++i;
                }
            }
        }
        if (!this.m_converged && this.m_hasRunLength) {
            if (this.m_table != null && this.m_table.model().executionTime() > this.m_maxCpuTime) {
                this.m_converged = false;
                this.m_table.model().converged().set();
            } else if (this.m_qtable != null && this.m_qtable.model().executionTime() > this.m_maxCpuTime) {
                this.m_converged = false;
                this.m_qtable.model().converged().set();
            }
            if (this.m_batchCount >= 50 && this.m_relError <= this.m_accuracy) {
                if (this.m_table != null) {
                    this.m_converged = true;
                    this.m_table.model().converged().set();
                } else if (this.m_qtable != null) {
                    this.m_converged = true;
                    this.m_qtable.model().converged().set();
                }
            }
        }
        this.m_obsCount = 0;
        this.m_sumObs = 0.0;
    }

    private boolean computeCorrelation() {
        int i;
        double[] rho = new double[6];
        double[] varOfCoeff = new double[6];
        int p = 1;
        while (p <= 5) {
            rho[p] = 0.0;
            i = 1;
            while (i <= this.m_batchCount - p) {
                int n = p;
                rho[n] = rho[n] + (this.m_batchMean[i] - this.m_meanOfMeans) * (this.m_batchMean[i + p] - this.m_meanOfMeans);
                ++i;
            }
            if (this.m_varOfMeans != 0.0) {
                int n = p;
                rho[n] = rho[n] / (this.m_varOfMeans * (double)this.m_batchCount);
            } else {
                rho[p] = 0.0;
            }
            ++p;
        }
        p = 1;
        while (p <= 5) {
            varOfCoeff[p] = 0.0;
            i = 1;
            while (i <= p - 1) {
                int n = p;
                varOfCoeff[n] = varOfCoeff[n] + rho[i] * rho[i];
                ++i;
            }
            varOfCoeff[p] = (1.0 + 2.0 * varOfCoeff[p]) / (double)this.m_batchCount;
            ++p;
        }
        boolean correlation = false;
        p = 1;
        while (p <= 5) {
            if (Math.abs(rho[p]) > 1.96 * Math.sqrt(varOfCoeff[p])) {
                correlation = true;
            }
            ++p;
        }
        return correlation;
    }

    private void computeConfidenceStatistics(double confLevel) {
        this.m_meanOfMeans = 0.0;
        this.m_halfWidth = 0.0;
        this.m_relError = 0.0;
        if (this.m_batchCount == 0) {
            return;
        }
        this.m_meanOfMeans = this.m_sumOfMeans / (double)this.m_batchCount;
        if (this.m_batchCount == 1) {
            return;
        }
        this.m_varOfMeans = (this.m_sumSqOfMeans - (double)this.m_batchCount * this.m_meanOfMeans * this.m_meanOfMeans) / (double)(this.m_batchCount - 1);
        if (this.m_varOfMeans < 0.0) {
            return;
        }
        this.m_halfWidth = this.tQuantile((1.0 - confLevel) / 2.0, this.m_batchCount - 1) * Math.sqrt(this.m_varOfMeans / (double)this.m_batchCount);
        if (this.m_meanOfMeans - this.m_halfWidth > 0.0) {
            this.m_relError = this.m_halfWidth / (this.m_meanOfMeans - this.m_halfWidth);
        } else if (this.m_meanOfMeans > 0.0) {
            this.m_relError = this.m_halfWidth / this.m_meanOfMeans;
        } else {
            return;
        }
    }

    private double tQuantile(double p, int ndf) {
        double[] h = new double[4];
        if (ndf == 0) {
            return 0.0;
        }
        double x = 0.0;
        double z1 = Math.abs(this.normalQuantile(p));
        double z2 = z1 * z1;
        h[0] = 0.25 * z1 * (z2 + 1.0);
        h[1] = 0.010416667 * z1 * ((5.0 * z2 + 16.0) * z2 + 3.0);
        h[2] = 0.002604167 * z1 * (((3.0 * z2 + 19.0) * z2 + 17.0) * z2 - 15.0);
        h[3] = z1 * ((((79.0 * z2 + 776.0) * z2 + 1482.0) * z2 - 1920.0) * z2 - 945.0);
        h[3] = h[3] * 1.0851E-5;
        int i = 3;
        while (i >= 0) {
            x = (x + h[i]) / (double)ndf;
            --i;
        }
        z1 += x;
        if (p > 0.5) {
            z1 = -z1;
        }
        return z1;
    }

    private double normalQuantile(double p) {
        double q = p > 0.5 ? 1.0 - p : p;
        double z1 = Math.sqrt(-2.0 * Math.log(q));
        double n = (0.010328 * z1 + 0.802853) * z1 + 2.515517;
        double d = ((0.001308 * z1 + 0.189269) * z1 + 1.43278) * z1 + 1.0;
        z1 -= n / d;
        if (p > 0.5) {
            z1 = -z1;
        }
        return z1;
    }
}

