/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.csim;

import com.mesquite.csim.AbstractResource;
import com.mesquite.csim.Model;
import com.mesquite.csim.Process;
import com.mesquite.csim.ProcessQueue;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Buffer
extends AbstractResource {
    private int m_size;
    private int m_current;
    private double m_startTime;
    private final ProcessQueue m_getQueue;
    private double m_getTimeLastChange;
    private int m_getTotal;
    private double m_getSum;
    private int m_getCount;
    private int m_getCurrent;
    private final ProcessQueue m_putQueue;
    private double m_putTimeLastChange;
    private int m_putTotal;
    private double m_putSum;
    private int m_putCount;
    private int m_putCurrent;
    private static final DecimalFormat s_timeFormat;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.mesquite.csim.Buffer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        s_timeFormat = new DecimalFormat("###0.000");
    }

    public Buffer(String name, int size) {
        this(name, size, Model.currentModel());
    }

    public Buffer(String name, int size, Model model) {
        super("buffer", name, model);
        this.m_size = size;
        this.m_current = 0;
        this.m_getQueue = new ProcessQueue();
        this.m_putQueue = new ProcessQueue();
        this.m_getTimeLastChange = this.m_putTimeLastChange = model.clock();
        this.m_putCurrent = 0;
        this.m_getCurrent = 0;
        this.reset();
        if (model.traceEnabled()) {
            Process p = model.getActiveProcess();
            String str = "init buffer " + this.name() + " size " + String.valueOf(this.m_size);
            model.traceEvent(p, str);
        }
    }

    public void collect() {
    }

    public void reset() {
        this.m_putTotal = 0;
        this.m_getTotal = 0;
        this.m_putSum = 0.0;
        this.m_getSum = 0.0;
        this.m_putCount = 0;
        this.m_getCount = 0;
        this.m_getQueue.reset();
        this.m_putQueue.reset();
        this.m_startTime = this.model().clock();
    }

    public void get(int amt) {
        this.model().checkThread();
        Process p = this.model().getActiveProcess();
        if (this.model().traceEnabled()) {
            String str = "get " + this.name() + " curr " + String.valueOf(this.m_current) + " amt " + String.valueOf(amt);
            this.model().traceEvent(str);
        }
        this.xget(p, amt);
        this.putSearch();
    }

    public void put(int amt) {
        this.model().checkThread();
        Process p = this.model().getActiveProcess();
        if (this.model().traceEnabled()) {
            String str = "put " + this.name() + " curr " + String.valueOf(this.m_current) + " amt " + String.valueOf(amt);
            this.model().traceEvent(str);
        }
        this.xput(p, amt);
        this.getSearch();
    }

    public boolean timed_get(int amt, double timeOut) {
        boolean result;
        Process p = this.model().getActiveProcess();
        this.model().checkThread();
        if (this.model().traceEnabled()) {
            String str = s_timeFormat.format(timeOut);
            this.model().traceEvent("time_get" + this.name() + " " + String.valueOf(amt) + " " + str);
        }
        this.model().schedule(timeOut);
        this.xget(p, amt);
        if (p.queue() != null) {
            if (!$assertionsDisabled && this.model().hasEvent(p)) {
                throw new AssertionError();
            }
            if (this.model().traceEnabled()) {
                this.model().traceEvent("timed_get timed_out at " + this.name());
            }
            this.m_getQueue.remove(p);
            result = false;
        } else {
            if (this.model().traceEnabled()) {
                this.model().traceEvent("timed_get got " + this.name());
            }
            if (this.model().hasEvent(p)) {
                this.model().cancel(p);
            }
            this.putSearch();
            result = true;
        }
        return result;
    }

    public boolean timed_put(int amt, double timeOut) {
        boolean result;
        Process p = this.model().getActiveProcess();
        this.model().checkThread();
        if (this.model().traceEnabled()) {
            String str = s_timeFormat.format(timeOut);
            this.model().traceEvent("time_put" + this.name() + " " + String.valueOf(amt) + " " + str);
        }
        this.model().schedule(timeOut);
        this.xput(p, amt);
        if (p.queue() != null) {
            if (!$assertionsDisabled && this.model().hasEvent(p)) {
                throw new AssertionError();
            }
            if (this.model().traceEnabled()) {
                this.model().traceEvent("timed_put timed_out at " + this.name());
            }
            this.m_putQueue.remove(p);
            result = false;
        } else {
            if (this.model().traceEnabled()) {
                this.model().traceEvent("timed_put got " + this.name());
            }
            if (this.model().hasEvent(p)) {
                this.model().cancel(p);
            }
            this.getSearch();
            result = true;
        }
        return result;
    }

    public double elapsedTime() {
        return this.model().clock() - this.m_startTime;
    }

    public int current() {
        return this.m_current;
    }

    public int size() {
        return this.m_size;
    }

    public int get_current() {
        return this.m_getCurrent;
    }

    public int put_current() {
        return this.m_putCurrent;
    }

    public int get_total() {
        return this.m_getTotal;
    }

    public int put_total() {
        return this.m_putTotal;
    }

    public int get_count() {
        return this.m_getCount;
    }

    public int put_count() {
        return this.m_putCount;
    }

    public double get_amount() {
        if ((double)this.get_count() > 0.0) {
            return this.get_total() / this.get_count();
        }
        return 0.0;
    }

    public double put_amount() {
        if ((double)this.put_count() > 0.0) {
            return this.put_total() / this.put_count();
        }
        return 0.0;
    }

    public double get_queueLength() {
        if (this.elapsedTime() > 0.0) {
            return this.get_timeQueue() / this.elapsedTime();
        }
        return 0.0;
    }

    public double put_queueLength() {
        if (this.elapsedTime() > 0.0) {
            return this.put_timeQueue() / this.elapsedTime();
        }
        return 0.0;
    }

    public double get_responseTime() {
        if ((double)this.get_count() > 0.0) {
            return this.get_timeQueue() / (double)this.get_count();
        }
        return 0.0;
    }

    public double put_responseTime() {
        if ((double)this.put_count() > 0.0) {
            return this.put_timeQueue() / (double)this.put_count();
        }
        return 0.0;
    }

    public double get_timeQueue() {
        return this.m_getSum;
    }

    public double put_timeQueue() {
        return this.m_putSum;
    }

    public ProcessQueue getQueue() {
        return this.m_getQueue;
    }

    public ProcessQueue putQueue() {
        return this.m_putQueue;
    }

    protected void xget(int amt) {
        Process p = this.model().getActiveProcess();
        this.xget(p, amt);
    }

    protected void xget(Process p, int amt) {
        p.storageRequest = amt;
        this.getJoin(amt);
        if (!this.m_getQueue.isEmpty() && p.priority() <= this.m_getQueue.peek().priority()) {
            this.m_getQueue.add(p);
            p.suspendAndFire();
            return;
        }
        int thisAmt = p.storageRequest;
        if (this.m_current < thisAmt) {
            this.m_getQueue.add(p);
            p.suspendAndFire();
            return;
        }
        thisAmt = p.storageRequest;
        this.getLeave(thisAmt);
        this.m_current -= thisAmt;
    }

    protected void xput(int amt) {
        Process p = this.model().getActiveProcess();
        this.xput(p, amt);
    }

    protected void xput(Process p, int amt) {
        this.putJoin(amt);
        p.storageRequest = amt;
        if (!this.m_putQueue.isEmpty() && p.priority() <= this.m_putQueue.peek().priority()) {
            this.m_putQueue.add(p);
            p.suspendAndFire();
            return;
        }
        int thisAmt = p.storageRequest;
        if (this.m_current + thisAmt > this.m_size) {
            this.m_putQueue.add(p);
            p.suspendAndFire();
            return;
        }
        thisAmt = p.storageRequest;
        this.putLeave(amt);
        this.m_current += thisAmt;
    }

    protected void getJoin(int amt) {
        this.m_getSum += (double)this.m_getCurrent * (this.model().clock() - this.m_getTimeLastChange);
        this.m_getTimeLastChange = this.model().clock();
        this.m_getCurrent += amt;
    }

    protected void getLeave(int amt) {
        this.m_getSum += (double)this.m_getCurrent * (this.model().clock() - this.m_getTimeLastChange);
        this.m_getTimeLastChange = this.model().clock();
        this.m_getCurrent -= amt;
        this.m_getTotal += amt;
        ++this.m_getCount;
    }

    protected void putJoin(int amt) {
        this.m_putSum += (double)this.m_putCurrent * (this.model().clock() - this.m_putTimeLastChange);
        this.m_putTimeLastChange = this.model().clock();
        this.m_putCurrent += amt;
    }

    protected void putLeave(int amt) {
        this.m_putSum += (double)this.m_putCurrent * (this.model().clock() - this.m_putTimeLastChange);
        this.m_putTimeLastChange = this.model().clock();
        this.m_putCurrent -= amt;
        this.m_putTotal += amt;
        ++this.m_putCount;
    }

    protected void getSearch() {
        while (!this.m_getQueue.isEmpty() && this.m_getQueue.peek().storageRequest <= this.m_current) {
            Process next = this.m_getQueue.remove();
            int nextAmt = next.storageRequest;
            if (this.model().traceEnabled()) {
                String str = "buffer " + this.name() + " gets " + String.valueOf(nextAmt) + " curr " + String.valueOf(this.m_current);
                this.model().traceEvent(next, str);
            }
            this.getLeave(nextAmt);
            this.m_current -= nextAmt;
            if (next.queue() != null) {
                next.queue().remove(next);
            } else if (this.model().hasEvent(next)) {
                this.model().cancel(next);
            }
            this.model().schedule(0.0, next);
        }
    }

    protected void putSearch() {
        while (!this.m_putQueue.isEmpty() && this.m_putQueue.peek().storageRequest + this.m_current <= this.m_size) {
            Process next = this.m_putQueue.remove();
            int nextAmt = next.storageRequest;
            if (this.model().traceEnabled()) {
                String str = "buffer " + this.name() + " puts " + String.valueOf(nextAmt) + " curr " + String.valueOf(this.m_current);
                this.model().traceEvent(next, str);
            }
            this.putLeave(nextAmt);
            this.m_current += nextAmt;
            if (next.queue() != null) {
                next.queue().remove(next);
            } else if (this.model().hasEvent(next)) {
                this.model().cancel(next);
            }
            this.model().schedule(0.0, next);
        }
    }

    public Process put_first_process() {
        return this.m_putQueue.peek();
    }

    public Process put_last_process() {
        return this.m_putQueue.lastProcess();
    }

    public Process put_remove_process(Process pr) {
        if (!this.m_putQueue.isEmpty()) {
            this.m_putQueue.remove(pr);
            if (this.model().traceEnabled()) {
                this.model().traceEvent("buffer.put " + this.name() + " remove " + pr.name() + "." + pr.identity());
            }
            return pr;
        }
        return null;
    }

    public void put_insert_process(Process pr) {
        if (this.model().traceEnabled()) {
            this.model().traceEvent("buffer.put " + this.name() + " insert " + pr.name() + "." + pr.identity());
        }
        this.m_putQueue.add(pr);
    }

    public List put_process_list() {
        LinkedList<Process> pList = new LinkedList<Process>();
        while (!this.m_putQueue.isEmpty()) {
            pList.add(this.m_putQueue.remove());
        }
        Iterator it = pList.iterator();
        while (it.hasNext()) {
            this.m_putQueue.add((Process)it.next());
        }
        return pList;
    }

    public Process get_first_process() {
        return this.m_getQueue.peek();
    }

    public Process get_last_process() {
        if (!this.m_getQueue.isEmpty()) {
            return this.m_getQueue.lastProcess();
        }
        return null;
    }

    public Process get_remove_process(Process pr) {
        if (!this.m_getQueue.isEmpty()) {
            this.m_getQueue.remove(pr);
            if (this.model().traceEnabled()) {
                this.model().traceEvent("buffer.get " + this.name() + " remove " + pr.name() + "." + pr.identity());
            }
            return pr;
        }
        return null;
    }

    public void get_insert_process(Process pr) {
        if (this.model().traceEnabled()) {
            this.model().traceEvent("buffer.get " + this.name() + " insert " + pr.name() + "." + pr.identity());
        }
        this.m_getQueue.add(pr);
    }

    public List get_process_list() {
        LinkedList<Process> pList = new LinkedList<Process>();
        while (!this.m_getQueue.isEmpty()) {
            pList.add(this.m_getQueue.remove());
        }
        Iterator it = pList.iterator();
        while (it.hasNext()) {
            this.m_getQueue.add((Process)it.next());
        }
        return pList;
    }
}

