/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.csim;

import com.mesquite.csim.AbstractStatKeeper;
import com.mesquite.csim.BasicQTable;
import com.mesquite.csim.BasicTable;
import com.mesquite.csim.Model;

public class Box
extends AbstractStatKeeper {
    private BasicTable m_sojourn_time = new BasicTable();
    private BasicQTable m_number_present = new BasicQTable();

    public Box(String name) {
        this(name, Model.currentModel());
    }

    public Box(String name, Model model) {
        super("box", name, model);
    }

    public double enter() {
        this.m_number_present.note_entry();
        return this.model().clock();
    }

    public void exit(double startTime) {
        this.m_number_present.note_exit();
        this.m_sojourn_time.record(this.model().clock() - startTime);
    }

    public void reset() {
        this.m_number_present.reset();
        this.m_sojourn_time.reset();
    }

    public BasicTable time_table() {
        return this.m_sojourn_time;
    }

    public BasicQTable number_qtable() {
        return this.m_number_present;
    }

    public void add_time_histogram(int num, double lo, double hi) {
        this.m_sojourn_time.add_histogram(num, lo, hi);
    }

    public void add_number_histogram(int num, int lo, int hi) {
        this.m_number_present.add_histogram(num, lo, hi);
    }

    public void time_confidence() {
        this.m_sojourn_time.confidence();
    }

    public void number_confidence() {
        this.m_number_present.confidence();
    }

    public void time_run_length(double accuracy, double confLevel, double maxCpuTime) {
        this.m_sojourn_time.run_length(accuracy, confLevel, maxCpuTime);
    }

    public void number_run_length(double accuracy, double confLevel, double maxCpuTime) {
        this.m_number_present.run_length(accuracy, confLevel, maxCpuTime);
    }
}

