/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.csim;

import com.mesquite.csim.ConfidenceInterval;
import com.mesquite.csim.Histogram;
import com.mesquite.csim.Model;

public class BasicTable {
    protected boolean m_basicTable = true;
    protected final Model m_model;
    private double m_startTime;
    private int m_count;
    private double m_max;
    private double m_min;
    private String m_name;
    private double m_sum;
    private double m_sumSquares;
    private Histogram m_histogram;
    private ConfidenceInterval m_confidence;

    public BasicTable() {
        this(Model.currentModel());
    }

    public BasicTable(Model model) {
        this.m_model = model;
        this.reset();
        this.m_histogram = null;
    }

    public boolean IsBasicTable() {
        return this.m_basicTable;
    }

    public void add_histogram(long n, double lo, double hi) {
        this.m_histogram = new Histogram(lo, hi, (hi - lo) / (double)n);
    }

    public void reset() {
        this.m_count = 0;
        this.m_min = 0.0;
        this.m_max = 0.0;
        this.m_sum = 0.0;
        this.m_sumSquares = 0.0;
        this.m_startTime = this.m_model.clock();
        if (this.m_histogram != null) {
            this.m_histogram.reset();
        }
        if (this.m_confidence != null) {
            this.m_confidence.reset();
        }
    }

    public void record(double value) {
        if (this.m_count == 0) {
            this.m_min = value;
            this.m_max = value;
        } else if (value < this.m_min) {
            this.m_min = value;
        } else if (value > this.m_max) {
            this.m_max = value;
        }
        ++this.m_count;
        this.m_sum += value;
        this.m_sumSquares += value * value;
        if (this.m_histogram != null) {
            this.m_histogram.update(value, 1.0);
        }
        if (this.m_confidence != null) {
            this.m_confidence.record(value);
        }
    }

    public final Model model() {
        return this.m_model;
    }

    public Histogram histogram() {
        return this.m_histogram;
    }

    public ConfidenceInterval getConfidenceInterval() {
        return this.m_confidence;
    }

    public double elapsedTime() {
        return this.m_model.clock() - this.m_startTime;
    }

    public int count() {
        return this.m_count;
    }

    public double cv() {
        double mn = this.mean();
        double std = this.stddev();
        if (mn == 0.0) {
            return 0.0;
        }
        return std / mn;
    }

    public double max() {
        return this.m_max;
    }

    public double mean() {
        if (this.m_count <= 0) {
            return 0.0;
        }
        return this.m_sum / (double)this.m_count;
    }

    public double min() {
        return this.m_min;
    }

    public int histogram_bucket(int i) {
        if (this.m_histogram == null) {
            return 0;
        }
        if (i < 0 || i > this.m_histogram.num() + 1) {
            return 0;
        }
        return this.m_histogram.bucket(i);
    }

    public double histogram_high() {
        if (this.m_histogram == null) {
            return 0.0;
        }
        return this.m_histogram.low() * this.m_histogram.width();
    }

    public double histogram_low() {
        if (this.m_histogram == null) {
            return 0.0;
        }
        return this.m_histogram.low();
    }

    public int histogram_num() {
        if (this.m_histogram == null) {
            return 0;
        }
        return this.m_histogram.num();
    }

    public double histogram_width() {
        if (this.m_histogram == null) {
            return 0.0;
        }
        return this.m_histogram.width();
    }

    public double histogram_total() {
        if (this.m_histogram == null) {
            return 0.0;
        }
        return this.m_histogram.total();
    }

    public double sum() {
        return this.m_sum;
    }

    public double sumSquares() {
        return this.m_sumSquares;
    }

    public double range() {
        return this.m_max - this.m_min;
    }

    public double stddev() {
        return Math.sqrt(this.var());
    }

    public double var() {
        if (this.count() <= 1) {
            return 0.0;
        }
        double mean = this.mean();
        double meanSq = mean * mean;
        return (this.m_sumSquares - (double)this.m_count * meanSq) / (double)(this.m_count - 1);
    }

    public void confidence() {
        this.m_confidence = new ConfidenceInterval(this);
    }

    public void run_length(double accuracy, double confidenceLevel, double cpuTimeLimit) {
        if (this.m_confidence == null) {
            this.m_confidence = new ConfidenceInterval(this);
        }
        this.m_confidence.addRunLength(accuracy, confidenceLevel, cpuTimeLimit);
    }

    public int batch_size() {
        if (this.m_confidence != null) {
            return this.m_confidence.batchSize();
        }
        return 0;
    }

    public int batch_count() {
        if (this.m_confidence != null) {
            return this.m_confidence.batchCount();
        }
        return 0;
    }

    public boolean converged() {
        if (this.m_confidence != null) {
            return this.m_confidence.converged();
        }
        return false;
    }

    public double conf_mean() {
        if (this.m_confidence != null) {
            return this.m_confidence.meanOfMeans(0.95);
        }
        return 0.0;
    }

    public double conf_halfwidth(double confLevel) {
        if (this.m_confidence != null) {
            return this.m_confidence.halfWidth(confLevel);
        }
        return 0.0;
    }

    public double conf_lower(double confLevel) {
        if (this.m_confidence != null) {
            return this.m_confidence.lower(confLevel);
        }
        return 0.0;
    }

    public double conf_upper(double confLevel) {
        if (this.m_confidence != null) {
            return this.m_confidence.upper(confLevel);
        }
        return 0.0;
    }

    public double conf_accuracy(double confLevel) {
        if (this.m_confidence != null) {
            return this.m_confidence.relativeError(confLevel);
        }
        return 0.0;
    }
}

