/*
 * Decompiled with CFR 0.152.
 */
package com.mesquite.csim;

import com.mesquite.csim.ConfidenceInterval;
import com.mesquite.csim.Histogram;
import com.mesquite.csim.Model;

public class BasicQTable {
    protected boolean m_basicQTable = true;
    private final Model m_model;
    private Histogram m_histogram;
    private double m_startTime;
    private double m_lastChange;
    private double m_current;
    private double m_max;
    private double m_min;
    private double m_sum;
    private double m_sumSquares;
    private double m_entries;
    private double m_exits;
    private ConfidenceInterval m_confidence;

    public BasicQTable() {
        this(Model.currentModel());
    }

    public BasicQTable(Model model) {
        this.m_model = model;
        this.m_current = 0.0;
        this.reset();
        this.m_histogram = null;
    }

    public boolean IsBasicQTable() {
        return this.m_basicQTable;
    }

    public void add_histogram(long n, long lo, long hi) {
        double incr = Math.ceil((double)(hi - lo) / (double)n);
        this.m_histogram = new Histogram(lo, hi, incr);
    }

    public void confidence() {
        this.m_confidence = new ConfidenceInterval(this);
    }

    public void run_length(double accuracy, double confLevel, double maxCpuTime) {
        if (this.m_confidence == null) {
            this.m_confidence = new ConfidenceInterval(this);
        }
        this.m_confidence.addRunLength(accuracy, confLevel, maxCpuTime);
    }

    public double batch_time() {
        if (this.m_confidence != null) {
            return this.m_confidence.batchTime();
        }
        return 0.0;
    }

    public int batch_count() {
        if (this.m_confidence != null) {
            return this.m_confidence.batchCount();
        }
        return 0;
    }

    public boolean converged() {
        if (this.m_confidence != null) {
            return this.m_confidence.converged();
        }
        return false;
    }

    public double conf_mean() {
        if (this.m_confidence != null) {
            return this.m_confidence.meanOfMeans(0.95);
        }
        return 0.0;
    }

    public double conf_halfwidth(double confLevel) {
        if (this.m_confidence != null) {
            return this.m_confidence.halfWidth(confLevel);
        }
        return 0.0;
    }

    public double conf_lower(double confLevel) {
        if (this.m_confidence != null) {
            return this.m_confidence.lower(confLevel);
        }
        return 0.0;
    }

    public double conf_upper(double confLevel) {
        if (this.m_confidence != null) {
            return this.m_confidence.upper(confLevel);
        }
        return 0.0;
    }

    public double conf_accuracy(double confLevel) {
        if (this.m_confidence != null) {
            return this.m_confidence.relativeError(confLevel);
        }
        return 0.0;
    }

    public void note_entry() {
        this.record_change(1.0);
    }

    public void note_exit() {
        this.record_change(-1.0);
    }

    public void note_value(int state) {
        this.record_change((double)state - this.m_current);
    }

    public void reset() {
        this.m_entries = 0.0;
        this.m_exits = 0.0;
        this.m_max = this.m_current;
        this.m_min = this.m_current;
        this.m_sum = 0.0;
        this.m_sumSquares = 0.0;
        this.m_lastChange = this.m_model.clock();
        this.m_startTime = this.m_model.clock();
        if (this.m_histogram != null) {
            this.m_histogram.reset();
        }
    }

    public void record_change(double change) {
        double elapsedTime;
        if (this.m_confidence != null) {
            this.m_confidence.record_change();
        }
        if ((elapsedTime = this.m_model.clock() - this.m_lastChange) >= 0.0) {
            this.m_sum += elapsedTime * this.m_current;
            this.m_sumSquares += elapsedTime * this.m_current * this.m_current;
            if (this.m_histogram != null) {
                this.m_histogram.update(this.m_current, elapsedTime);
            }
            if (change != 0.0) {
                this.m_current += change;
                if (this.m_current > this.m_max) {
                    this.m_max = this.m_current;
                }
                if (this.m_current < this.m_min) {
                    this.m_min = this.m_current;
                }
                if (change > 0.0) {
                    this.m_entries += change;
                } else {
                    this.m_exits -= change;
                }
            }
            this.m_lastChange = this.m_model.clock();
        }
    }

    public Histogram histogram() {
        return this.m_histogram;
    }

    public ConfidenceInterval getConfidenceInterval() {
        return this.m_confidence;
    }

    public final Model model() {
        return this.m_model;
    }

    public double elapsedTime() {
        return this.m_model.clock() - this.m_startTime;
    }

    public int entries() {
        return (int)this.m_entries;
    }

    public int exits() {
        return (int)this.m_exits;
    }

    public int min() {
        return (int)this.m_min;
    }

    public int max() {
        return (int)this.m_max;
    }

    public int range() {
        return (int)(this.m_max - this.m_min);
    }

    public int current() {
        return (int)this.m_current;
    }

    public double last_change() {
        return this.m_lastChange;
    }

    public double sum() {
        double width = this.m_model.clock() - this.m_lastChange;
        double tempSum = this.m_sum + width * this.m_current;
        return tempSum;
    }

    public double realSum() {
        return this.m_sum;
    }

    public double sumSquares() {
        double width = this.m_model.clock() - this.m_lastChange;
        double tempSumSquares = this.m_sumSquares + width * this.m_current * this.m_current;
        return tempSumSquares;
    }

    public double mean() {
        double tempMean = this.m_model.elapsedTime() > 0.0 ? this.sum() / this.m_model.elapsedTime() : 0.0;
        return tempMean;
    }

    public double var() {
        double tempMean = this.mean();
        double tempVar = this.m_model.elapsedTime() > 0.0 ? this.sumSquares() / this.m_model.elapsedTime() - tempMean * tempMean : 0.0;
        return tempVar;
    }

    public double stddev() {
        double tempVar = this.var();
        double tempStddev = Math.sqrt(tempVar);
        return tempStddev;
    }

    public double cv() {
        double tempMean = this.mean();
        double tempCv = tempMean > 0.0 ? this.stddev() / tempMean : 0.0;
        return tempCv;
    }

    public long hist_num() {
        return this.m_histogram.num();
    }

    public double hist_low() {
        return this.m_histogram.low();
    }

    public double hist_high() {
        return this.m_histogram.high();
    }

    public double hist_width() {
        return this.m_histogram.width();
    }

    public double hist_total() {
        return this.m_histogram.total();
    }

    public double hist_bucket(int i) {
        return this.m_histogram.xbucket(i);
    }
}

