/* file: util.c */
/* 
 * CSim - Discrete system simulation library
 * 
 * Copyright (C) 2002 Vikas G P <vikasgp@users.sourceforge.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */
#include <stdlib.h>
#include "util.h"
#include <stdio.h>
#include <string.h>

/* Try to allocate memory and fail if not successful */
void *xmalloc(size_t size)
{
	 register void *value = malloc(size);
	 if(value != NULL){
		 return value;
	 }
	 else{
		 die("ERROR - Can't allocate memory");
		 return NULL; /* compiler happiness */
	 }
}

/* Try to duplicate a string and fail if not successful */
char *xstrdup(char *string)
{
	register void *dup = (void *)strdup(string);
	if( dup != NULL ){
		return (char *)dup;
	}
	else{
		die("ERROR - Can't allocate memory");
		return NULL; /* compiler happiness */
	}
}

/* Exit with a dying message */
void die(char *message)
{
	fprintf(stderr,"Csim: %s\n",message);
	exit(1);
}

/* Print an informational message */
void info(char *message)
{
	fprintf(stderr,"Csim: %s\n",message);
	return;
}
