
#include "csim.h"
#include "queue.h"
#include "util.h"

/* Creates a new set */

CsSet *cs_set_new(int discipline)
{
	CsSet *set = (CsSet *)xmalloc(sizeof(CsSet));
	set->queue = queue_new();
	if( ! (discipline == FIFO || discipline == LIFO) ){
		return NULL;
	}
	set->discipline = discipline;
	set->count = 0;
	return set;
}

/* Files an entity in a set */

void cs_set_file(CsSet *set, CsEntity *entity)
{
	CsQueueNode *node = queue_node_new();
	node->data = entity;
	if(set->discipline == FIFO){	/* Queue */
		queue_node_append(set->queue, node);
	}
	else{		/* Stack */
		queue_node_prepend(set->queue, node);
	}
	(set->count)++;
}

/* Returns the top-most member of the set */

CsEntity *cs_set_remove(CsSet *set)
{
	CsQueueNode *node;
	if( cs_set_is_empty(set) ){
		return NULL;
	}
	(set->count)--;
	node = queue_node_pop(set->queue);
	return node->data;
}

/* Number of elements */

int cs_set_count_elements(CsSet *set)
{
	return set->count;
}

/* Non-destructively returns the top-most element */

CsEntity *cs_set_remove_nodestroy(CsSet *set)
{
	CsQueueNode *node;
	if( cs_set_is_empty(set) ){
		return NULL;
	}
	node = queue_node_pop(set->queue);
	queue_node_prepend(set->queue, node);
	return node->data;
}

/* Destroys a set */

void cs_set_destroy(CsSet *set)
{
	queue_destroy(set->queue);
	free(set);
}

