/* 
 * CSim - Discrete system simulation library
 * 
 * Copyright (C) 2002 Vikas G P <vikasgp@users.sourceforge.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#ifndef __QUEUE_H__
#define __QUEUE_H__

/* Each node of a queue has a CsQueueNode */
typedef struct _CsQueueNode CsQueueNode;
struct _CsQueueNode{
	CsQueueNode *backward;
	CsQueueNode *forward;
	void *key;
	void *data; 
};

/* Each queue has a CsQueue */
typedef struct _CsQueue CsQueue;
struct _CsQueue{
	CsQueueNode *head;
	CsQueueNode *tail;
};

CsQueueNode *queue_node_pop(CsQueue *queue);
CsQueue *queue_new(void);
CsQueueNode *queue_node_new(void);
void queue_node_append(CsQueue *queue, CsQueueNode *node);
int queue_node_insert_sorted( CsQueue *queue,
			       CsQueueNode *node,
			       int(*greater)(void *, void *)
			     );
int queue_destroy(CsQueue *queue);
int queue_node_destroy(CsQueueNode *node);
void queue_node_prepend(CsQueue *queue, CsQueueNode *node);


#endif   /* __QUEUE_H__  */
