/* 
 * CSim - Discrete system simulation library
 * 
 * Copyright (C) 2002 Vikas G P <vikasgp@users.sourceforge.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "csim.h"
#include "queue.h"
#include "util.h"
#include "event.h"

/* The global current clock time */
simtime_t current_time;

/* The global event queue */
CsQueue *event_queue;

/* Initializes the library, should be called before using any routines */

int cs_init(void)
{
	event_queue = queue_new();
	current_time = 0;
	return 0;
}

/* The main simulation loop */
int cs_start_simulation(void)
{
	CsQueueNode *next_node = queue_node_pop(event_queue);
	CsEventNotice *next_notice = next_node->data;
	CsEvent *next_event = next_notice->event;
	while(next_node != NULL){
		next_notice = next_node->data;
                next_event = next_notice->event;
		current_time = next_notice->scheduled_time;
		(*(next_event->event_routine))(next_notice->user_data);
		(next_event->count)++;
		queue_node_destroy(next_node);
		next_node = queue_node_pop(event_queue);
	}
	return 0;
}

