include(macros.m4)
BEGIN

HEADER

FUNC(Creating an entity,
     CsEntity *cs_entity_new(void);,
     `Creates a new entity. Returns a pointer to a CsEntity structure, which must 
      be supplied to other functions operating on an entity.'
     )
RETURN(`Pointer to the new entity')


FUNC(Destroying an entity, 
    void cs_entity_destroy(CsEntity *entity);,
    `Destroys an entity, freeing up the space used by it.'
    ) 	
ARGS(`entity', `The entity to be destroyed')


FUNC(Adding attributes,
      void cs_attribute_add(CsEntity *entity, char *name);,
      `Adds an attribute to an entitys list of attributes. Each attribute,
      represented by an internal structure, contains a name and a (int) value. 
      The values can only be set through functions.'
    )
ARGS(`entity', `The entity to which to add the attribute',
     `name', `The name of the attribute'
    )
RETURN(`0 if the attribute does not already exist, and -1 if it does')
       
FUNC(Setting attributes,
     int cs_attribute_set(CsEntity *entity, char *name, int new_value);,
     Sets an attribute to the specified value.
    )	
ARGS(`entity', `The relevent entity',
	`name', `The name of the attribute',
	`new_value', `The value to be set'
    )
RETURN(`0 if the attribute exists, -1 if not.')


FUNC(Getting attributes,
     int cs_attribute_set(CsEntity *entity, char *name);,
     `Gets the value of an attribute, an	error message is printed if the 
     attribute does not exist.'
    )
ARGS(`entity', `The relevent entity',
     `name', `Name of the attribute'
    )
RETURN(`The value of the attribute if it exists, -1 if not. In the latter case,
dies with a message if DIE_ON_NO_ATTR is defined in config.h')


FUNC(Specifying attributes at once,
     `void cs_attribute_specify(CsEntity *entity, char **attr_names);',
     `This is a faster way to specify all the attributes of an entity. It takes 
     a char **attr_names as an argument, which is like **argv. The array contains
     the names of the attributes of an entity. The function just calls 
     cs_attribute_add on all of the names.'
    )
ARGS(`entity', `The entity of which the attributes are being specified',
     `attr_names', `An array of pointers to strings containing names of attributes'
    )

FUNC(Creating temporary entities,
     `CsEntity *cs_entity_new_with_attributes(char **attr_names)',
     `This is just cs_entity_new() and cs_attribute_specify() acting at once.
      This can be useful to create "temporary entities", meaning they may be 
      destroyed soon. With this function, the attr_names array becomes a sort
      of a "template" for creating entities, without laboriously calling two
      functions'
     )
ARGS(`attr_names', `Same as that in cs_attribute_specify')
RETURN(`Pointer to the newly created entity')


FOOTER
END
