#include "csim.h"
#include <stdio.h>
  
CsEntity *t_entity;
CsEntity *t_entity1;
CsEvent *t_event;
CsSet *t_set;

int t_routine(void *data);
  
int main(){
	printf("Initializing\n");
	cs_init();
	
	printf("Creating entities and event\n");
	t_entity = cs_entity_new();
	t_entity1 = cs_entity_new();
	t_event = cs_event_new(t_routine);

	printf("Adding attribute\n");
	cs_attribute_add(t_entity,"t_attr");
	
	printf("Setting\n");
	cs_attribute_set(t_entity,"t_attr",1);
	
	printf("Getting: attr is %d\n",cs_attribute_get(t_entity,"t_attr"));
	
	printf("Creating a LIFO set\n");
	t_set = cs_set_new(LIFO);

	printf("Filing \n");
	cs_set_file(t_set, t_entity);
	cs_set_file(t_set, t_entity1);

	printf("Removing \n");
	t_entity1 = cs_set_remove(t_set);
	t_entity = cs_set_remove(t_set);
		
	printf("Scheduling\n");
	cs_event_schedule(t_event, 1, NULL);
	
	printf("Starting simulation\n");
	cs_start_simulation();
	
	return 0;
}

int t_routine(void *data)
{
	printf("Event occured at %d\n",(int)cs_get_clock_time());
	cs_event_schedule_relative(t_event, -1, NULL);
	return 0;
}

