/*
 * Decompiled with CFR 0.152.
 */
package org.cynetec.lib.system.net.ntp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.net.ntp.NtpV3Impl;
import org.apache.commons.net.ntp.NtpV3Packet;
import org.apache.commons.net.ntp.TimeStamp;
import org.apache.log4j.Logger;

public class NTPUDPServer
extends Thread {
    private Logger log = Logger.getLogger(this.getClass());
    public static final int DEFAULT_PORT = 123;
    private AtomicBoolean terminated = new AtomicBoolean(false);
    private DatagramSocket datagramSocket;

    public NTPUDPServer() throws IOException {
        this(123);
    }

    public NTPUDPServer(int port) throws IOException {
        this.datagramSocket = new DatagramSocket(port);
    }

    @Override
    public void run() {
        NtpV3Impl recMessage = new NtpV3Impl();
        DatagramPacket receivePacket = recMessage.getDatagramPacket();
        while (!this.terminated.get() && !this.datagramSocket.isClosed()) {
            try {
                this.datagramSocket.receive(receivePacket);
                this.handlePacket((NtpV3Packet)recMessage, System.currentTimeMillis());
                recMessage = new NtpV3Impl();
                receivePacket = recMessage.getDatagramPacket();
            }
            catch (IOException e) {
                this.log.warn((Object)"could not receive datagram packet", (Throwable)e);
            }
            try {
                Thread.sleep(25L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void handlePacket(NtpV3Packet recMessage, long receiveTimeMillis) {
        NtpV3Impl message = new NtpV3Impl();
        DatagramPacket sendPacket = message.getDatagramPacket();
        sendPacket.setAddress(recMessage.getDatagramPacket().getAddress());
        sendPacket.setPort(recMessage.getDatagramPacket().getPort());
        message.setMode(4);
        message.setVersion(3);
        message.setLeapIndicator(0);
        message.setStratum(1);
        message.setPoll(4);
        message.setReferenceId(1);
        message.setOriginateTimeStamp(recMessage.getTransmitTimeStamp());
        message.setReceiveTimeStamp(TimeStamp.getNtpTime((long)receiveTimeMillis));
        TimeStamp now = TimeStamp.getCurrentTime();
        message.setReferenceTime(now);
        message.setTransmitTime(now);
        try {
            this.datagramSocket.send(sendPacket);
        }
        catch (IOException e) {
            this.log.warn((Object)"could not send response datagram packet", (Throwable)e);
        }
    }

    public void terminate() {
        this.terminated.set(true);
        this.interrupt();
    }
}

