/*
 * Decompiled with CFR 0.152.
 */
package org.cynetec.lib.system.net.ntp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.net.ntp.NTPUDPClient;
import org.apache.commons.net.ntp.TimeInfo;
import org.apache.log4j.Logger;
import org.cynetec.lib.system.net.ntp.NTPTimeUpdateStatusListener;

public class NTPTime
extends Thread {
    private Logger log = Logger.getLogger(this.getClass());
    private final SimpleDateFormat simpleDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private AtomicBoolean terminated = new AtomicBoolean(false);
    private NTPUDPClient ntpClient = new NTPUDPClient();
    private long syncInterval;
    private String ntpServer;
    private int ntpServerPort;
    private long relativeTimeBase;
    private long systemTimeBase;
    private NTPTimeUpdateStatusListener listener;

    public NTPTime() {
        this(null, 0L);
    }

    public NTPTime(String ntpServer, long syncInterval) {
        this(ntpServer, 123, syncInterval);
    }

    public NTPTime(String ntpServer, int ntpServerPort, long syncInterval) {
        this(ntpServer, 123, syncInterval, null);
    }

    public NTPTime(String ntpServer, int ntpServerPort, long syncInterval, NTPTimeUpdateStatusListener listener) {
        this.ntpClient.setDefaultTimeout(5000);
        this.syncInterval = syncInterval;
        this.ntpServer = ntpServer;
        this.ntpServerPort = ntpServerPort;
        this.listener = listener;
        this.setName("NTPTime Thread");
        this.setSyncTime(System.currentTimeMillis());
    }

    public synchronized void setUpdateStatusListener(NTPTimeUpdateStatusListener listener) {
        this.listener = listener;
    }

    public synchronized NTPTimeUpdateStatusListener getUpdateStatusListener() {
        return this.listener;
    }

    public synchronized void setSyncInterval(long syncInterval) {
        this.syncInterval = syncInterval;
    }

    public synchronized void setNTPServer(String ntpServer) {
        this.ntpServer = ntpServer;
    }

    public synchronized void setNTPServerPort(int ntpServerPort) {
        this.ntpServerPort = ntpServerPort;
    }

    private synchronized void setSyncTime(long relativeTimeBase) {
        this.systemTimeBase = System.currentTimeMillis();
        this.relativeTimeBase = relativeTimeBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.terminated.get()) {
            NTPTime nTPTime;
            int ntpServerPort;
            String ntpServer;
            long syncInterval;
            NTPTime nTPTime2 = this;
            synchronized (nTPTime2) {
                if (this.listener != null) {
                    this.listener.ntpStatusChange(NTPTimeUpdateStatusListener.NTPUpdateStatus.UPDATING);
                }
            }
            NTPTime nTPTime3 = this;
            synchronized (nTPTime3) {
                syncInterval = this.syncInterval;
                ntpServer = this.ntpServer;
                ntpServerPort = this.ntpServerPort;
            }
            try {
                InetAddress host = InetAddress.getByName(ntpServer);
                TimeInfo timeInfo = this.ntpClient.getTime(host, ntpServerPort);
                timeInfo.computeDetails();
                this.setSyncTime(System.currentTimeMillis() + timeInfo.getOffset());
                boolean isSNTP = false;
                if (timeInfo.getMessage().getPoll() == 0) {
                    isSNTP = true;
                }
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("setting reference time to: " + this.simpleDate.format(new Date(this.getNTPTimeMillis())) + " / " + this.simpleDate.format(new Date()) + " from [" + (isSNTP ? "S/NTP" : timeInfo.getMessage().getType()) + " " + timeInfo.getMessage().getVersion() + " " + timeInfo.getMessage().getReferenceIdString() + "]"));
                }
                NTPTime nTPTime4 = this;
                synchronized (nTPTime4) {
                    if (this.listener != null) {
                        this.listener.ntpStatusChange(NTPTimeUpdateStatusListener.NTPUpdateStatus.SUCCEEDED);
                    }
                }
            }
            catch (UnknownHostException e) {
                this.log.error((Object)("could not sync time: unknown host " + ntpServer + " - " + e.getMessage()));
                nTPTime = this;
                synchronized (nTPTime) {
                    if (this.listener != null) {
                        this.listener.ntpStatusChange(NTPTimeUpdateStatusListener.NTPUpdateStatus.FAILED);
                    }
                }
            }
            catch (IOException e) {
                this.log.error((Object)("could not sync time with " + ntpServer + " - " + e.getMessage()));
                nTPTime = this;
                synchronized (nTPTime) {
                    if (this.listener != null) {
                        this.listener.ntpStatusChange(NTPTimeUpdateStatusListener.NTPUpdateStatus.FAILED);
                    }
                }
            }
            try {
                Thread.sleep(syncInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void terminate() {
        this.terminated.set(true);
        this.interrupt();
    }

    public synchronized long getNTPTimeMillis() {
        return this.relativeTimeBase + (System.currentTimeMillis() - this.systemTimeBase);
    }
}

