/*
 * Decompiled with CFR 0.152.
 */
package org.cynetec.lib.logging;

import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.varia.NullAppender;

public class LoggingUtils {
    private static Logger root = Logger.getRootLogger();

    public static void initNullLogging() {
        root.addAppender((Appender)new NullAppender());
    }

    public static void initConsoleLogging() {
        root.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%d{ISO8601} %-5p [%t] %c{1}: %m%n")));
    }

    public static void setDebug(boolean debug) {
        if (debug) {
            root.setLevel(Level.ALL);
        } else {
            root.setLevel(Level.WARN);
        }
    }

    public static void setLoggingLevel(Level level) {
        root.setLevel(level);
    }
}

